package com.xforceplus.phoenix.tools.enums;

import java.util.stream.Stream;

/**
 * @program: phoenix-purchaser-tools
 * @description:
 * @author: cuixiangyu
 * @created: 2020-09-11 09:38
 */
public enum FileTypeDictEnum {
    /**
     * 常用文件的文件头如下：(以前六位为准) JPEG (jpg)，文件头：FFD8FF PNG (png)，文件头：89504E47 GIF (gif)，文件头：47494638 TIFF (tif)，文件头：49492A00 Windows Bitmap (bmp)，文件头：424D CAD (dwg)，文件头：41433130 Adobe Photoshop
     * (psd)，文件头：38425053 Rich Text Format (rtf)，文件头：7B5C727466 XML (xml)，文件头：3C3F786D6C HTML (html)，文件头：68746D6C3E Email [thorough only] (eml)，文件头：44656C69766572792D646174653A Outlook Express
     * (dbx)，文件头：CFAD12FEC5FD746F Outlook (pst)，文件头：2142444E MS Word/Excel (xls.or.doc)，文件头：D0CF11E0 MS Access (mdb)，文件头：5374616E64617264204A WordPerfect (wpd)，文件头：FF575043 Postscript
     * (eps.or.ps)，文件头：252150532D41646F6265 Adobe Acrobat (pdf)，文件头：255044462D312E Quicken (qdf)，文件头：AC9EBD8F Windows Password (pwl)，文件头：E3828596 ZIP Archive (zip)，文件头：504B0304 RAR Archive
     * (rar)，文件头：52617221 Wave (wav)，文件头：57415645 AVI (avi)，文件头：41564920 Real Audio (ram)，文件头：2E7261FD Real Media (rm)，文件头：2E524D46 MPEG (mpg)，文件头：000001BA MPEG (mpg)，文件头：000001B3 Quicktime
     * (mov)，文件头：6D6F6F76 Windows Media (asf)，文件头：3026B2758E66CF11 MIDI (mid)，文件头：4D546864
     */

    JPG("FFD8FF", "jpg"),
    PNG("89504E47", "png"),
    ZIP("504B030414000008", "zip"),
    RAR("52617221", "rar"),
    PDF("255044462D312E", "pdf"),
    OFD("504B030414000000", "ofd"),
    XML("3C3F786D6C", "xml"),
    ;


    private String fileHeader;

    private String fileSuffix;

    FileTypeDictEnum(String fileHeader, String fileSuffix) {
        this.fileHeader = fileHeader;
        this.fileSuffix = fileSuffix;
    }

    public String getFileHeader() {
        return fileHeader;
    }

    public String getFileSuffix() {
        return fileSuffix;
    }

    public static String checkType(String type) {
        return Stream.of(FileTypeDictEnum.values()).filter(r ->
                r.getFileHeader().equals(type.substring(0, r.getFileHeader().length())))
            .findFirst().orElse(FileTypeDictEnum.JPG).getFileSuffix();
    }

    public static FileTypeDictEnum getFileType(String fileHeader) {
        return Stream.of(FileTypeDictEnum.values()).filter(r ->
                r.getFileHeader().equals(fileHeader.substring(0, r.getFileHeader().length())))
            .findFirst().orElse(null);
    }

}
