package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumIntValue;

public enum InvoiceOriginEnum implements IEnumIntValue {

    SELLER_DIRECT(11, "销方直连"),
    SELLER_EXTRACT(12, "销方抽取"),
    SELLER_MANUAL(13, "销方手工回填"),
    VERIFY(21, "国税验真"),
    AUTH(22, "国税底账"),
    RECOGNIZE(31, "影像识别"),
    OUTER_INTERFACE(33, "外部接口上传"),
    TAX_WARE(41, "税件推送"),
    PURCHASER_ASSIST(42, "票税助手");

    private final Integer code;
    private final String desc;

    InvoiceOriginEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public Integer code(){
        return code;
    }

    public String desc(){
        return desc;
    }

    @Override
    public Integer value() {
        return code;
    }
}
