package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumIntValue;

public enum InvoiceSendTypeEnum implements IEnumIntValue {

    SEND_SELLER(1, "下发销项"),
    SEND_JANUS(2, "下发集成"),
    SEND_COOPERATE(3, "下发协同"),
    SEND_NEW_INVOICE(4, "下发新发票池");

    private final Integer code;
    private final String msg;

    InvoiceSendTypeEnum(Integer code, String msg){
        this.code = code;
        this.msg = msg;
    }

    public Integer code(){
        return code;
    }

    public String msg(){
        return msg;
    }

    @Override
    public Integer value() {
        return code;
    }
}
