package com.xforceplus.phoenix.tools.enums;
import com.xforceplus.phoenix.tools.enums.base.IEnumStringValue;

/**
 * @author liuda
 * @version 1.0
 * @date 2021/5/1 17:57
 * 发票联次枚举
 */
public enum InvoiceSheetEnum implements IEnumStringValue {

    /**
     * 发票联
     */
    INVOICE_SHEET("1", "发票联"),
    /**
     * 抵扣联
     */
    DEDUCTION_SHEET("2", "抵扣联"),
    /**
     * 存根联
     */
    STUB_SHEET("3", "存根联"),
    /**
     * 记账联
     */
    CHARGE_SHEET("4", "记账联");

    private final String code;
    private final String msg;

    InvoiceSheetEnum(String code, String msg){
        this.code = code;
        this.msg = msg;
    }

    public String code(){
        return code;
    }

    public String msg(){
        return msg;
    }

    @Override
    public String value() {
        return code;
    }
}
