package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumStringValue;
import java.util.stream.Stream;

public enum NoDeductReasonEnum implements IEnumStringValue {
    NO_DEDUCT_REASON_1("1","用于非应税项目"),
    NO_DEDUCT_REASON_2("2","用于免税项目"),
    NO_DEDUCT_REASON_3("3","用户集体福利或者个人消费"),
    NO_DEDUCT_REASON_4("4","遭受非正常损失"),
    NO_DEDUCT_REASON_5("5","其他");
    private final String code;
    private final String description;

    NoDeductReasonEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @Override
    public String value() {
        return this.code;
    }

    public String getDescription() {
        return description;
    }

    public static NoDeductReasonEnum fromValue(String value) {
        return Stream.of(NoDeductReasonEnum.values())
            .filter(t -> t.value().equals(value))
            .findFirst().orElse(null);
    }
}
