package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumIntValue;

/**
 * @author liuda
 * @version 1.0
 * @date 2021/8/30 15:14
 */
public enum OperateEnum implements IEnumIntValue {
    /**
     * 删除
     */
    OPERATE_DELETE_0(0,"删除"),
    /**
     * 修改
     */
    OPERATE_UPDATE_1(1,"修改"),
    /**
     * 新增
     */
    OPERATE_INSERT_2(2,"新增"),
    ;

    private final Integer value;
    private final String   desc;

    OperateEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public Integer value() {
        return this.value;
    }

    public String getDesc() {
        return desc;
    }
}
