package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumIntValue;

/**
 * @program: phoenix-purchaser-tools
 * @description: 付款状态枚举
 * @author: cuixiangyu
 * @created: 2020-05-07 10:00
 */
public enum PaymentStatusEnum implements IEnumIntValue {
    /**
     * 未付款
     */
    NOT_PAY(0,"未付款"),
    /**
     * 部分付款
     */
    PART_PAY(1,"部分付款"),
    /**
     * 已付款
     */
    COMPLETE_PAY(2,"已付款"),
    ;

    private final Integer value;
    private final String description;

    PaymentStatusEnum(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    @Override
    public Integer value() {
        return this.value;
    }

    public String getDescription() {
        return description;
    }
}
