package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumIntValue;

public enum RecogStatusEnum implements IEnumIntValue {
    /**
     * 未识别
     */
    UNRECOGNIZED(0, "未识别"),
    /**
     * 已识别
     */
    RECOGNIZED(1, "已识别");

    private final Integer code;
    private final String msg;

    RecogStatusEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer code() {
        return code;
    }

    public String msg() {
        return msg;
    }

    @Override
    public Integer value() {
        return code;
    }
}
