package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumStringValue;

/**
 * @author liuda
 * @version 1.0
 * @date 2021/8/11 16:04 租户功能点枚举()
 */
public enum TenantFunctionCodeEnum implements IEnumStringValue {
    NEW_INVOICE("1", "切新发票池"),
    SOURCE_FILE_PUSH("2", "源文件调用电子影像接口"),
    DELETE_INVOICE_RECOG("3", "影像删除调用电子影像接口"),
    TAX_NO_MORE_TENANT_CONFIG("4", "一税号多租户组织配置"),
    TAX_URL_CHANGE("5", "国税地址转平台地址"),
    INVOICE_STATUS_NO_CANCEL_MATCH("6", "蓝票指定状态不执行取消配单"),
    ;

    private final String code;
    private final String description;

    TenantFunctionCodeEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @Override
    public String value() {
        return this.code;
    }

    public String getDescription() {
        return description;
    }
}
