package com.xforceplus.phoenix.tools.function;

import java.util.function.BiFunction;

/**
 * @program: phoenix-purchaser-tools
 * @description 函数式接口扩展
 * @author: wdye
 * @created: 2020-07-07 13:58
 */
public class BiFunctional<T, U, R> {
    /**
     * 对异常封装捕获以listener的方式去优雅处理
     *
     * @param function
     * @param t
     * @param u
     * @param listener
     * @return
     */
    public R apply(BiFunction<T, U, R> function, T t, U u, ExecuteListener<R> listener) {
        R r = null;
        try {
            r = function.apply(t, u);
            listener.last(r);
        } catch (Exception e) {
            listener.exception(e, r);
            if (listener.isThrow()) {
                throw e;
            }
        }
        return r;
    }
}
