package com.xforceplus.phoenix.tools.transaction;

import com.xforceplus.phoenix.tools.constant.RedissonConstants;
import com.xforceplus.phoenix.tools.exception.LockException;
import org.redisson.api.RLock;

import java.util.concurrent.TimeUnit;

/**
 * @program: phoenix-purchaser-tools
 * @description
 * @author: wdye
 * @created: 2020-06-13 09:40
 */
public class BaseLockService {

    protected void fastTryLock(RLock lock, long lockLeaseTimeMillSecond) {
        tryLock(lock, 0, lockLeaseTimeMillSecond);
    }

    protected void tryLock(RLock lock, long lockLeaseTimeMillSecond) {
        tryLock(lock, RedissonConstants.LOCK_NORMAL_WAIT_TIME_MILLI_SECOND, lockLeaseTimeMillSecond);
    }

    protected void tryLock(RLock lock, long lockWaitTimeMillSecond, long lockLeaseTimeMillSecond) {
        try {
            boolean lockFlag = lock.tryLock(lockWaitTimeMillSecond, lockLeaseTimeMillSecond, TimeUnit.MILLISECONDS);
            if (!lockFlag) {
                throw new LockException(String.format("锁: %s 尝试获取失败", lock.toString()));
            }
        } catch (InterruptedException e) {
            throw new LockException(e.getMessage());
        }
    }

    protected void unLock(boolean releaseLock, RLock lock) {
        if (releaseLock) {
            lock.unlock();
        }
    }
}
