package com.xforceplus.phoenix.tools.transaction;

import com.xforceplus.phoenix.tools.transaction.consumer.Function3;
import org.redisson.api.RLock;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * @program: phoenix-purchaser-tools
 * @description 事务调度者含锁
 * @author: wdye
 * @created: 2019-11-05 16:18
 */
public interface TransactionLockServiceInvoker {

    /**
     * 基于RedissonClient线程安全的
     *
     * @param lockKey
     * @param runnable
     */
    void callWithLock(String lockKey, Runnable runnable);

    /**
     * 新起事务带锁
     *
     * @param lock
     * @param runnable
     */
    void callNewTxWithLock(RLock lock, Runnable runnable);

    /**
     * 新起事务带锁
     *
     * @param lock
     * @param lockLeaseTimeMillisecond
     * @param runnable
     */
    void callNewTxWithLock(RLock lock, long lockLeaseTimeMillisecond, Runnable runnable);

    /**
     * 新起事务带锁
     *
     * @param lock
     * @param consumer
     * @param arg1
     * @param <A1>
     */
    <A1> void callNewTxWithLock(RLock lock, Consumer<A1> consumer, A1 arg1);

    /**
     * 新起事务带锁
     *
     * @param lock
     * @param supplier
     * @param <R>
     * @return
     */
    <R> R callNewTxWithLock(RLock lock, Supplier<R> supplier);

    /**
     * 新起事务带锁
     *
     * @param lock
     * @param function
     * @param arg1
     * @param <A1>
     * @param <R>
     * @return
     */
    <A1, R> R callNewTxWithLock(RLock lock, Function<A1, R> function, A1 arg1);

    /**
     * 新起事务带锁
     *
     * @param lock
     * @param lockLeaseTimeMillISecond
     * @param function
     * @param arg1
     * @param <A1>
     * @param <R>
     * @return
     */
    <A1, R> R callNewTxWithLock(RLock lock, long lockLeaseTimeMillISecond, Function<A1, R> function, A1 arg1);

    /**
     * 新起事务带锁
     *
     * @param lock
     * @param biFunction
     * @param arg1
     * @param arg2
     * @param <A1>
     * @param <A2>
     * @param <R>
     * @return
     */
    <A1, A2, R> R callNewTxWithLock(RLock lock, BiFunction<A1, A2, R> biFunction, A1 arg1, A2 arg2);

    /**
     * 新起事务带锁
     *
     * @param lock
     * @param lockLeaseTimeMillISecond
     * @param function3
     * @param arg1
     * @param arg2
     * @param arg3
     * @param <A1>
     * @param <A2>
     * @param <A3>
     * @param <R>
     * @return
     */
    <A1, A2, A3, R> R callNewTxWithLock(RLock lock, long lockLeaseTimeMillISecond, Function3<A1, A2, A3, R> function3, A1 arg1, A2 arg2, A3 arg3);
}
