package com.xforceplus.phoenix.tools.transaction;

import java.util.function.Supplier;

/**
 * @program: phoenix-purchaser-tools
 * @description 事务提交或完成后事件处理
 * @author: wdye
 * @created: 2019-11-01 13:32
 */
public interface TransactionalEventService {

    /**
     * 事务完成后执行(提交后会被执行，执行的方法不新启事务)
     *
     * @param runnable
     */
    void callTxAfterCommit(Runnable runnable);

    /**
     * 事务完成后执行(提交/回滚都会被执行，执行的方法不新启事务)
     *
     * @param runnable
     */
    void callTxAfterComplete(Runnable runnable);

    /**
     * 事务完成后执行(提交/回滚都会被执行，执行的方法不新启事务)
     * 不传入参数，返回一个值
     *
     * @param supplier
     */
    void callTxAfterComplete(Supplier supplier);

    /**
     * 事务完成后执行(提交后执行，执行的方法新启事务)
     * 不传入参数，返回一个值
     *
     * @param runnable
     */
    void callNewTxAfterCommit(Runnable runnable);

    /**
     * 事务完成后执行(提交后异步执行，执行的方法新启事务)
     *
     * @param runnable
     */
    void callNewAsyncTxAfterCommit(Runnable runnable);

    /**
     * 事务完成后执行(提交后执行，执行的方法新启事务)
     * 不传入参数，返回一个值
     *
     * @param supplier
     */
    void callNewTxAfterCommit(Supplier supplier);
}
