package com.xforceplus.phoenix.tools.util;

import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.Optional;

import static org.apache.commons.lang3.StringUtils.EMPTY;

/**
 * @program: phoenix-purchaser-tools
 * @description 空对象转换工具
 * @author: wdye
 * @created: 2020-03-12 18:59
 */
public class NullableUtil {
    private NullableUtil() {
    }

    /**
     * Object转String
     * <p>
     * value=null 则返回 defaultValue
     * </p>
     *
     * @param value
     * @param defaultValue
     * @return
     */
    public static String toStringValue(Object value, String defaultValue) {
        return value == null || EMPTY.equals(value) ? defaultValue : String.valueOf(value);
    }

    /**
     * Object转Integer
     * <p>
     * value=null 则返回 defaultValue
     * </p>
     *
     * @param value
     * @param defaultValue
     * @return
     */
    public static Integer toIntValue(Object value, Integer defaultValue) {
        if (null == value || StringUtils.isEmpty(String.valueOf(value))) {
            return defaultValue;
        }
        return Integer.valueOf(value.toString());
    }

    /**
     * Object转BigDecimal
     * <p>
     * value=null 则返回 defaultValue
     * </p>
     *
     * @param value
     * @param defaultValue
     * @return
     */
    public static BigDecimal toBigDecimalValue(Object value, BigDecimal defaultValue) {
        return value == null || EMPTY.equals(value) ? defaultValue : new BigDecimal(value.toString());
    }

    /**
     * Object转Long
     * <p>
     * value=null 则返回 defaultValue
     * </p>
     *
     * @param value
     * @param defaultValue
     * @return
     */
    public static Long toLongValue(Object value, Long defaultValue) {
        if (null == value) {
            return defaultValue;
        }
        return Long.valueOf(value.toString());
    }
}
