package com.xforceplus.phoenix.tools.util;

import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.HibernateValidator;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import java.util.Map;
import java.util.Set;

/**
 * Describe: 参数验证器
 */
public class ParamValidatorUtil {

    /**
     * 参数验证(返回 String 验证结果)
     *
     * @param input 数据对象
     * @return
     */
    public static String checkParamsStr(Object input) {
        return checkParamsStr(input, true);
    }

    /**
     * 参数验证(返回 String 验证结果)
     *
     * @param input    数据对象
     * @param failFast true:检测到非法参数立即返回；false: 检测全部参数&返回所有异常
     * @return
     */
    public static String checkParamsStr(Object input, boolean failFast) {
        Set<ConstraintViolation<Object>> constraintViolations = checkParamsSets(input, failFast);

        if (!constraintViolations.isEmpty()) {
            // 字段重复判断
            Map<String, String> regVerify = Maps.newHashMap();
            for (ConstraintViolation<Object> ipiv : constraintViolations) {
                // 多个验证条件时取最后验证条件message
                regVerify.put(ipiv.getPropertyPath().toString(), ipiv.getMessage());
            }
            String join = StringUtils.join(regVerify.values(), "；");
            return join;
        }
        return null;
    }

    /**
     * 参数验证(返回 set验证结果)
     *
     * @param input    数据对象
     * @param failFast true:检测到非法参数立即返回；false: 检测全部参数&返回所有异常
     * @return
     */
    public static <T> Set<ConstraintViolation<T>> checkParamsSets(T input, boolean failFast) {

        ValidatorFactory validatorFactory = Validation.byProvider(HibernateValidator.class)
                .configure()
                .failFast(failFast)
                .buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();

        return validator.validate(input);
    }
}
