package com.xforceplus.phoenix.tools.util;

import java.util.regex.Pattern;

/**
 * @author zhanglong
 */
public class RegexUtil {

    private static final String NUMBER_REGEX = "^-?\\d+(\\.\\d+)?$";
    private static final String ENGLISH_NUMBER_REGEX = "^[\\d\\/\\\\a-zA-Z_-]+$";
    private static final String MOBILE_REGEX = "^[1][0-9][0-9]{9}$";
    private static final String PHONE_REGEX = "^[1-9]{1}[0-9]{5,8}$";
    private static final String PHONE_WITH_ZONE_REGEX = "^[0][1-9]{2,3}-[0-9]{5,10}$";
    private static final String AMOUNT_REGEX = "(^[0-9]{1,12}$)|(^[0-9]{1,12}[\\.]{1}[0-9]{1,6}$)";
    private static final String EMAIL_REGEX = "^[a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$";

    private RegexUtil() {
    }

    /**
     * 判断是否邮箱
     *
     * @param str
     * @return
     */
    public static boolean isEmail(final String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        return str.matches(EMAIL_REGEX);
    }

    /**
     * 判断一个字符串是否是数字。
     *
     * @param str
     * @return
     */
    public static boolean isNumber(final String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        Pattern pattern = Pattern.compile(NUMBER_REGEX);
        return pattern.matcher(str).matches();
    }

    /**
     * 判断 只能输入英文字母、数字、-、/、\
     *
     * @param str
     * @return
     */
    public static boolean isContractNumber(final String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        Pattern pattern = Pattern.compile(ENGLISH_NUMBER_REGEX);
        return pattern.matcher(str).matches();
    }

    /**
     * 手机号验证
     *
     * @param str
     * @return
     */
    public static boolean isMobile(final String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        Pattern pattern = Pattern.compile(MOBILE_REGEX);
        return pattern.matcher(str).matches();
    }

    /**
     * 电话号码验证
     *
     * @param str
     * @return
     */
    public static boolean isPhone(final String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        Pattern pattern = str.length() > 9 ? Pattern.compile(PHONE_WITH_ZONE_REGEX) : Pattern.compile(PHONE_REGEX);
        return pattern.matcher(str).matches();
    }

    /**
     * 12位整数或小数点最多6位
     *
     * @param str
     * @return
     */
    public static boolean isAmount(final String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        Pattern pattern = Pattern.compile(AMOUNT_REGEX);
        return pattern.matcher(str).matches();
    }
}
