package com.xforceplus.phoenix.tools.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

/**
 * @program: phoenix-purchaser-tools
 * @description 字符串工具类
 * <p>
 * 只存放通用工具包(Guava/Spring/Apache)没有的方法
 * </p>
 * @author: wdye
 * @created: 2020-06-29 13:56
 */
public final class StrUtil {
    final static String commaRegex = ",|，";
    private StrUtil() {
    }

    /**
     * 截取最后length条
     *
     * @param str
     * @param length
     * @return
     */
    public static String subLast(String str, int length) {
        int strLength = StringUtils.length(str);
        if (strLength == 0) {
            return null;
        }
        return StringUtils.substring(str, strLength > length ? strLength - length : 0);
    }

    /**
     * 两个字符串比较,忽略特殊字符
     * @param s1
     * @param s2
     * @return
     */
    public static boolean strCompare(String s1, String s2) {
        if(StringUtils.isEmpty(s1)){
            s1 = StringUtils.EMPTY;
        }
        if(StringUtils.isEmpty(s2)){
            s2 = StringUtils.EMPTY;
        }
        return discombobulate(s1).equals(discombobulate(s2));
    }

    private static String discombobulate(String s) {
        String REGEX = "[^0-9a-zA-Z\u4e00-\u9fa5.，,。？“”]+";
        return s.replaceAll(REGEX, "").toLowerCase();
    }

    public static List<String> strSplit(String str){
        if (StringUtils.isEmpty(str)){
            return Lists.newArrayList();
        }
        return Stream.of(str.split(commaRegex)).collect(Collectors.toList());
    }
}
