package com.xforceplus.phoenix.tools.util.validator;

import java.util.regex.Matcher;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;

public class NotEmptyPatternValidator implements ConstraintValidator<NotEmptyPattern, String> {
    private NotEmptyPattern notEmptyPattern;
    private java.util.regex.Pattern pattern;
    @Override
    public void initialize(NotEmptyPattern notEmptyPattern) {
        this.notEmptyPattern = notEmptyPattern;
        this.pattern = java.util.regex.Pattern.compile(notEmptyPattern.regexp());
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if(StringUtils.isEmpty(value)){
            return true;
        }
        Matcher m = this.pattern.matcher(value);
        return m.matches();
    }
}

