/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.util;

import com.xforceplus.phoenix.tools.enums.FileTypeDictEnum;
import com.xforceplus.phoenix.tools.util.FileX509TrustManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);
    static final Pattern pattern = Pattern.compile("\\S*[?]\\S*");

    private FileUtil() {
    }

    public static boolean createFile(String destFileName) {
        File file = new File(destFileName);
        if (file.exists()) {
            return false;
        }
        if (destFileName.endsWith(File.separator)) {
            return false;
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            log.error("{}", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String requestUrlToBase64(String fileUrl) {
        String result = null;
        HttpURLConnection connection = null;
        try {
            if (fileUrl.contains("https")) {
                SSLContext sslcontext = SSLContext.getInstance("SSL", "SunJSSE");
                sslcontext.init(null, new TrustManager[]{new FileX509TrustManager()}, new SecureRandom());
                HostnameVerifier ignoreHostnameVerifier = (s, sslsession) -> true;
                HttpsURLConnection.setDefaultHostnameVerifier(ignoreHostnameVerifier);
                HttpsURLConnection.setDefaultSSLSocketFactory(sslcontext.getSocketFactory());
            }
            URL url = new URL(fileUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            InputStream inputStream = connection.getInputStream();
            int len = -1;
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((len = inputStream.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            result = new String(Base64.getEncoder().encode(out.toByteArray()));
            connection.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return result;
    }

    public static String getFileSuffix(InputStream inputStream) throws Exception {
        byte[] b = new byte[8];
        inputStream.read(b, 0, b.length);
        StringBuilder stringBuilder = new StringBuilder();
        if (b == null || b.length <= 0) {
            return null;
        }
        for (int i = 0; i < b.length; ++i) {
            int v = b[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        String fileHeader = stringBuilder.toString().toUpperCase();
        return FileTypeDictEnum.checkType(fileHeader);
    }

    public static FileTypeDictEnum getFileSuffix2(InputStream inputStream) throws Exception {
        byte[] b = new byte[8];
        inputStream.read(b, 0, b.length);
        StringBuilder stringBuilder = new StringBuilder();
        if (b == null || b.length <= 0) {
            return null;
        }
        for (int i = 0; i < b.length; ++i) {
            int v = b[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        String fileHeader = stringBuilder.toString().toUpperCase();
        return FileTypeDictEnum.getFileType(fileHeader);
    }

    public static String parseSuffix(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        Matcher matcher = pattern.matcher(url);
        String[] spUrl = url.split("/");
        int len = spUrl.length;
        String endUrl = spUrl[len - 1];
        if (matcher.find()) {
            String[] spEndUrl = endUrl.split("\\?");
            return spEndUrl[0].split("\\.")[1];
        }
        return endUrl.split("\\.")[1];
    }
}

