/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.pscc.common.exception;

import com.xforceplus.pscc.common.dto.CommonResponse;
import com.xforceplus.pscc.common.exception.BusinessException;
import com.xforceplus.pscc.common.intercept.TraceContext;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
@Order
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public CommonResponse<?> handleException(Exception e, HttpServletResponse response) {
        log.error(e.getMessage(), (Throwable)e);
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return CommonResponse.failed("\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002" + TraceContext.getContextTraceId());
    }

    @ExceptionHandler(value={BusinessException.class})
    @ResponseBody
    public CommonResponse<?> handleException(BusinessException e, HttpServletResponse response) {
        log.error(e.getMessage(), (Throwable)e);
        if (e.getErrorCode() != null) {
            response.setStatus(e.getErrorCode().getErrCode().intValue());
        } else {
            response.setStatus(HttpStatus.OK.value());
        }
        return CommonResponse.failed(e.getMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseBody
    public CommonResponse<?> illegalArgumentException(IllegalArgumentException e, HttpServletResponse response) {
        log.error(e.getMessage(), (Throwable)e);
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return CommonResponse.failed("\u975e\u6cd5\u53c2\u6570\u5f02\u5e38" + TraceContext.getContextTraceId());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public CommonResponse<?> handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        log.error(e.getMessage(), (Throwable)e);
        BindingResult bindingResult = e.getBindingResult();
        StringBuilder errorMsg = new StringBuilder();
        if (bindingResult.hasErrors()) {
            List errors = bindingResult.getAllErrors();
            for (ObjectError objectError : errors) {
                FieldError fieldError = (FieldError)objectError;
                if (log.isDebugEnabled()) {
                    log.error("Data check failure : object: {},field: {},errorMessage: {}", new Object[]{fieldError.getObjectName(), fieldError.getField(), fieldError.getDefaultMessage()});
                }
                errorMsg.append(objectError.getDefaultMessage());
                errorMsg.append(",");
            }
            errorMsg = new StringBuilder(errorMsg.substring(0, errorMsg.length() - 1));
        }
        return CommonResponse.failed(errorMsg.toString() + TraceContext.getContextTraceId());
    }
}

