/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.pscc.common.janus;

import com.xforceplus.apollo.client.netty.IMessageListener;
import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.apollo.client.utils.SealedMessageBuilder;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.pscc.common.dto.CommonResponse;
import com.xforceplus.pscc.common.exception.ApplicationException;
import com.xforceplus.pscc.common.intercept.TraceContext;
import com.xforceplus.pscc.common.janus.MessageHandler;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JanusListener
implements IMessageListener {
    private static final Logger log = LoggerFactory.getLogger(JanusListener.class);
    private MCFactory mcFactory;
    private static final Map<String, MessageHandler> handleMap = new HashMap<String, MessageHandler>();

    public JanusListener(MCFactory mcFactory) {
        this.mcFactory = mcFactory;
    }

    public void putHandleMap(String name, MessageHandler handler) {
        handleMap.put(name, handler);
    }

    public boolean onMessage(SealedMessage sealedMessage) {
        boolean flag = true;
        SealedMessage msg = null;
        SealedMessage.Header header = sealedMessage.getHeader();
        String playLoadId = header.getPayLoadId();
        String msgId = header.getMsgId();
        String traceId = TraceContext.putContextTraceId(msgId);
        String requestName = header.getRequestName();
        try {
            MessageHandler messageHandler;
            String body = sealedMessage.getPayload().getObj().toString();
            log.info("\u6d88\u606f\u961f\u5217\u76d1\u542c\u5668\u63a5\u6536\u5230\u3010{}\u3011\u961f\u5217,payLoadId\u3010{}\u3011,msgId\u3010{}\u3011", new Object[]{requestName, playLoadId, msgId});
            log.info("\u6d88\u606f\u5185\u5bb9\uff1a{}", (Object)body);
            CommonResponse response = null;
            if ("request_receipt".equals(requestName)) {
                messageHandler = handleMap.get(header.getOthers().get("sourceRequestName"));
                if (messageHandler != null) {
                    messageHandler.receiveReceipt(sealedMessage);
                } else {
                    log.info("\u56de\u6267\u65e0\u9700\u5904\u7406!");
                }
            } else {
                messageHandler = handleMap.get(requestName);
                if (messageHandler != null) {
                    response = messageHandler.handle(sealedMessage);
                } else {
                    throw new ApplicationException("\u65e0\u6cd5\u627e\u5230\u3010{}\u3011\u961f\u5217\u5904\u7406\u89c4\u5219\uff0c\u65e0\u6cd5\u8fdb\u884c\u5904\u7406\uff01\uff01\uff01", requestName);
                }
            }
            if (response != null) {
                boolean reslut = response.getCode() == 1;
                msg = SealedMessageBuilder.buildReceiptMessage((SealedMessage)sealedMessage, (boolean)reslut, (String)(traceId + ":" + response.getMessage()));
            }
        }
        catch (Exception e) {
            flag = false;
            msg = SealedMessageBuilder.buildReceiptMessage((SealedMessage)sealedMessage, (boolean)flag, (String)(traceId + ":" + e.getMessage()));
            log.error("ReceiveMsgListener.onMessage() error! --- netty\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01", (Throwable)e);
        }
        try {
            if (msg != null && !"request_receipt".equals(requestName)) {
                this.mcFactory.sendMessage(msg);
            }
        }
        catch (Exception e) {
            log.error("ReceiveMsgListener.onMessage() error! --- netty\u53d1\u9001\u56de\u6267\u5f02\u5e38\uff01", (Throwable)e);
        }
        TraceContext.removeContextTraceId();
        return flag;
    }

    public MCFactory getMcFactory() {
        return this.mcFactory;
    }

    public void setMcFactory(MCFactory mcFactory) {
        this.mcFactory = mcFactory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JanusListener)) {
            return false;
        }
        JanusListener other = (JanusListener)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MCFactory this$mcFactory = this.getMcFactory();
        MCFactory other$mcFactory = other.getMcFactory();
        return !(this$mcFactory == null ? other$mcFactory != null : !this$mcFactory.equals(other$mcFactory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JanusListener;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MCFactory $mcFactory = this.getMcFactory();
        result = result * 59 + ($mcFactory == null ? 43 : $mcFactory.hashCode());
        return result;
    }

    public String toString() {
        return "JanusListener(mcFactory=" + this.getMcFactory() + ")";
    }
}

