/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.pscc.common.janus;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.xforceplus.apollo.client.http.HttpClientFactory;
import com.xforceplus.pscc.common.exception.ApplicationException;
import com.xforceplus.pscc.common.intercept.TraceContext;
import com.xforceplus.pscc.common.janus.ActionName;
import com.xforceplus.pscc.common.janus.JanusConfig;
import com.xforceplus.pscc.common.janus.JanusService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class JanusServiceImpl
implements JanusService {
    private static final Logger log = LoggerFactory.getLogger(JanusServiceImpl.class);
    private static final String PREFIX = "pscc.common.janus";
    private final JanusConfig janusConfig;

    @Override
    public JanusConfig.ActionData getActionData(ActionName actionName) {
        if (MapUtils.isEmpty(this.janusConfig.getActionMap())) {
            throw new ApplicationException("\u672a\u914d\u7f6e\u53c2\u6570:\u96c6\u6210\u5e73\u53f0action,\u914d\u7f6eprefix:pscc.common.janus.actionMap");
        }
        JanusConfig.ActionData actionData = this.janusConfig.getActionMap().get(actionName.getKey());
        if (actionData == null) {
            throw new ApplicationException("\u672a\u627e\u5230\u5bf9\u5e94action,key:{},name:{}", actionName.getKey(), actionName.getName());
        }
        return actionData;
    }

    @Override
    public JSONObject send(ActionName actionName, Map<String, Object> params) {
        JanusConfig.ActionData actionData = this.getActionData(actionName);
        return this.send(actionData, actionName, null, params, TraceContext.getContextTraceId());
    }

    @Override
    public JSONObject send(ActionName actionName, Map<String, Object> params, String serialNo) {
        JanusConfig.ActionData actionData = this.getActionData(actionName);
        return this.send(actionData, actionName, null, params, serialNo);
    }

    @Override
    public JSONObject send(ActionName actionName, Map<String, String> headerMap, Map<String, Object> params, String serialNo) {
        JanusConfig.ActionData actionData = this.getActionData(actionName);
        return this.send(actionData, actionName, headerMap, params, serialNo);
    }

    private JSONObject send(JanusConfig.ActionData actionData, ActionName actionName, Map<String, String> header, Map<String, Object> params, String serialNo) {
        this.check();
        Map<String, String> headerMap = header;
        String url = this.janusConfig.getHttpUrl();
        String paramStr = JSON.toJSONString(params);
        try {
            HttpClientFactory httpClientFactory = HttpClientFactory.getHttpClientFactory((String)url, (String)this.janusConfig.getAuthentication());
            if (CollectionUtils.isEmpty(header)) {
                headerMap = new HashMap<String, String>();
            }
            headerMap.put("rpcType", "http");
            headerMap.put("Authentication", this.janusConfig.getAuthentication());
            headerMap.put("action", actionData.getAction());
            headerMap.put("Accept-Encoding", "deflate");
            headerMap.put("serialNo", StringUtils.isBlank((CharSequence)serialNo) ? UUID.randomUUID().toString() : serialNo);
            headerMap.put("tenantId", this.janusConfig.getTenantId());
            headerMap.put("tenantCode", this.janusConfig.getTenantCode());
            headerMap.put("uiaSign", this.janusConfig.getUiaSign());
            log.info("\u8c03\u7528\u96c6\u6210\u5e73\u53f0\u63a5\u53e3 serialNo:[{}] ,\u8c03\u7528\u5730\u5740:[{}],\u8c03\u7528\u65b9\u6cd5\u540d:[{}],\u53c2\u6570:{},header:{}", new Object[]{serialNo, url, actionName.getName(), paramStr, headerMap});
            HashSet<String> keySet = new HashSet<String>(headerMap.keySet());
            for (String key : keySet) {
                if (headerMap.get(key) != null) continue;
                headerMap.remove(key);
            }
            String resp = StringUtils.equals((CharSequence)"get", (CharSequence)actionData.getMethod()) ? httpClientFactory.get(actionData.getAction(), params, headerMap) : httpClientFactory.post(actionData.getAction(), headerMap, paramStr, null);
            log.info("\u8c03\u7528\u96c6\u6210\u5e73\u53f0\u63a5\u53e3\u6210\u529f serialNo:[{}] ,\u8c03\u7528\u5730\u5740:[{}],\u8c03\u7528\u65b9\u6cd5\u540d:[{}],\u8fd4\u56de\u503c:{}", new Object[]{serialNo, url, actionName.getName(), resp});
            return JSONObject.parseObject((String)resp);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u96c6\u6210\u5e73\u53f0\u63a5\u53e3\u5931\u8d25 serialNo:[{}] ,\u8c03\u7528\u5730\u5740:[{}],\u8c03\u7528\u65b9\u6cd5\u540d:[{}],\u9519\u8bef\u539f\u56e0:{}", new Object[]{serialNo, url, actionName.getName(), e.getMessage()});
            throw new ApplicationException(e);
        }
    }

    private void check() {
        if (StringUtils.isBlank((CharSequence)this.janusConfig.getHttpUrl())) {
            throw new ApplicationException("\u672a\u914d\u7f6e\u53c2\u6570:\u96c6\u6210\u5e73\u53f0url,\u914d\u7f6eprefix:pscc.common.janus.httpUrl");
        }
        if (StringUtils.isBlank((CharSequence)this.janusConfig.getAuthentication())) {
            throw new ApplicationException("\u672a\u914d\u7f6e\u53c2\u6570:\u96c6\u6210\u5e73\u53f0authentication,\u914d\u7f6eprefix:pscc.common.janus.authentication");
        }
    }

    public JanusServiceImpl(JanusConfig janusConfig) {
        this.janusConfig = janusConfig;
    }
}

