/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.pscc.common.starter;

import com.xforceplus.apollo.client.netty.IMessageListener;
import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.pscc.common.janus.JanusConfig;
import com.xforceplus.pscc.common.janus.JanusListener;
import com.xforceplus.pscc.common.janus.MessageHandler;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="pscc.common.janus", name={"tcpUrl", "clientId"}, matchIfMissing=false)
public class JanuxTcpStarterConfiguration
implements ApplicationContextAware,
ApplicationRunner {
    private ApplicationContext applicationContext;
    private final JanusConfig janusConfig;

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void run(ApplicationArguments args) throws Exception {
        MCFactory mcFactory = MCFactory.getInstance((String)this.janusConfig.getClientId(), (String)this.janusConfig.getTcpUrl(), (int)this.janusConfig.getTcpPort());
        JanusListener janusListener = new JanusListener(mcFactory);
        Map handlerMap = this.applicationContext.getBeansOfType(MessageHandler.class);
        if (!MapUtils.isEmpty((Map)handlerMap)) {
            handlerMap.values().forEach(handler -> janusListener.putHandleMap(handler.getRequestName(), (MessageHandler)handler));
        }
        mcFactory.registerListener((IMessageListener)janusListener);
    }

    public JanuxTcpStarterConfiguration(ApplicationContext applicationContext, JanusConfig janusConfig) {
        this.applicationContext = applicationContext;
        this.janusConfig = janusConfig;
    }
}

