package com.xforceplus.pscc.common.bot;

import java.util.List;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Data
@Configuration
@ConfigurationProperties(prefix = "pscc.common.bot")
public class BotConfig {

    private String dingBotUrl = "https://oapi.dingtalk.com/robot";

    private String dingBotToken;

    private String dingBotKey;

    private List<String> warningCall;

    private Integer warningType = 1;

    private Integer warningCountThres;

    private Integer warningCountThresByOne = 2;

    private Integer warningMinutesThres = 20;

}
