package com.xforceplus.pscc.common.bot;

import com.alibaba.fastjson.JSON;
import org.apache.commons.codec.binary.Base64;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import java.net.URLEncoder;
import java.util.*;

public class BotHelper {

    /**
     * 机器人Text类型消息组装，自定义@对象
     */
    public static String getText(String text, List<String> phones) {
        Map<String, Object> message = new HashMap<>();
        Map<String, String> textMap = new HashMap<>();
        Map<String, List<String>> atMap = new HashMap<>();
        textMap.put("content", text);
        atMap.put("atMobiles", phones);
        message.put("msgtype", "text");
        message.put("text", textMap);
        message.put("at", atMap);
        return JSON.toJSONString(message);
    }

    /**
     * 把timestamp+"\n"+密钥当做签名字符串，使用HmacSHA256算法计算签名，
     * 然后进行Base64 encode，最后再把签名参数再进行urlEncode，得到最终的签名（需要使用UTF-8字符集）
     */
    public static String getTimestampAndSign(String key) throws Exception{
        Long timestamp = System.currentTimeMillis();
        String stringToSign = timestamp + "\n" + key;
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256"));
        byte[] signData = mac.doFinal(stringToSign.getBytes("UTF-8"));
        String sign = URLEncoder.encode(new String(Base64.encodeBase64(signData)),"UTF-8");
        return String.format("&timestamp=%s&sign=%s", timestamp, sign);
    }

}
