package com.xforceplus.pscc.common.bot;

import com.xforceplus.pscc.common.exception.ApplicationException;
import com.xforceplus.pscc.common.util.OkHttpClientUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import okhttp3.Response;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Slf4j
@Service
@AllArgsConstructor
public class BotService {

    private final BotConfig botConfig;

    public void sendInfo(String text) throws Exception {
        String url = botConfig.getDingBotUrl()
                + "/send?access_token=" + botConfig.getDingBotToken()
                + BotHelper.getTimestampAndSign(botConfig.getDingBotKey());
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        String body = BotHelper.getText(text, botConfig.getWarningCall());
        Response resp = OkHttpClientUtil.doPost(url, headerMap, null, body);
        if (HttpStatus.OK.value() != resp.code()) {
            String message = null;
            if (resp.body() != null) {
                message = resp.body().string();
            }
            throw new ApplicationException("返回失败!code:{},message:{}", resp.code(), message);
        }
    }

    public void sendInfo(String text, List<String> phones) throws Exception {
        String url = botConfig.getDingBotUrl()
                + "/send?access_token=" + botConfig.getDingBotToken()
                + BotHelper.getTimestampAndSign(botConfig.getDingBotKey());
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        String body = BotHelper.getText(text, phones);
        Response resp = OkHttpClientUtil.doPost(url, headerMap, null, body);
        if (HttpStatus.OK.value() != resp.code()) {
            String message = null;
            if (resp.body() != null) {
                message = resp.body().string();
            }
            throw new ApplicationException("返回失败!code:{},message:{}", resp.code(), message);
        }
    }

    public void sendInfo(String text, String dingBotToken, String dingBotKey, List<String> phones) throws Exception {
        String url = botConfig.getDingBotUrl()
                + "/send?access_token=" + dingBotToken
                + BotHelper.getTimestampAndSign(dingBotKey);
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        String body = BotHelper.getText(text, phones);
        Response resp = OkHttpClientUtil.doPost(url, headerMap, null, body);
        if (HttpStatus.OK.value() != resp.code()) {
            String message = null;
            if (resp.body() != null) {
                message = resp.body().string();
            }
            throw new ApplicationException("返回失败!code:{},message:{}", resp.code(), message);
        }
    }

}
