package com.xforceplus.pscc.common.dto;

public class CommonResponse<T> {

    public static final String OK = "1";
    public static final String Fail = "0";
    public static final String SPECIAL = "99";

    /**
     * return code,0失败 1成功
     */
    private String code;
    /**
     * 返回结果提示
     */
    private String message;
    /**
     * 返回结果
     */
    private T result;

    public CommonResponse() {
    }

    public static CommonResponse ok(String message) {
        return ok(message, (Object) null);
    }

    public static CommonResponse SPECIAL(String message) {
        return SPECIAL(message, (Object) null);
    }

    public static <T> CommonResponse<T> ok(String message, T result) {
        return from(OK, message, result);
    }

    public static <T> CommonResponse<T> SPECIAL(String message, T result) {
        return from(SPECIAL, message, result);
    }

    public static CommonResponse failed(String message) {
        return from(Fail, message);
    }

    public static CommonResponse from(String code, String message) {
        return from(code, message, (Object) null);
    }

    public static <T> CommonResponse<T> from(String code, String message, T result) {
        CommonResponse response = new CommonResponse();
        response.setCode(code);
        response.setMessage(message);
        response.setResult(result);
        return response;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public String toString() {
        return "CommonResponse{code=" + this.code + ", message='" + this.message + '\'' + ", result=" + this.result + '}';
    }

}
