package com.xforceplus.pscc.common.exception;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * @author zjj
 * @Description 业务异常
 * @date 2021-01-04 16:32
 */
@Data
public class ApplicationException extends RuntimeException {

    private ErrorCode errorCode;
    private final String message;

    public ApplicationException(String message) {
        super(message);
        this.message = message;
    }

    public ApplicationException(ErrorCode errorCode) {
        super(errorCode.getErrDesc());
        this.errorCode = errorCode;
        this.message = errorCode.getErrDesc();
    }

    public ApplicationException(Throwable throwable, String format, Object... objects) {
        super(formatMessage(format, objects), throwable);
        this.message = formatMessage(format, objects);
    }

    public ApplicationException(Throwable throwable) {
        super(throwable.getMessage(), throwable);
        this.message = throwable.getMessage();
    }

    public ApplicationException(String format, Object... objects) {
        super(formatMessage(format, objects));
        this.message = formatMessage(format, objects);
    }

    private static String formatMessage(String format, Object... objects) {
        final String formatStr = StringUtils.replace(format, "{}", "%s");
        return String.format(formatStr, objects);
    }

}
