package com.xforceplus.pscc.common.exception;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * @author zjj
 * @Description 业务异常
 * @date 2021-01-04 16:32
 */
@Data
public class BusinessException extends RuntimeException {

    private ErrorCode errorCode;
    private final String message;

    public BusinessException(String message) {
        super(message);
        this.message = message;
    }

    public BusinessException(ErrorCode errorCode) {
        super(errorCode.getErrDesc());
        this.errorCode = errorCode;
        this.message = errorCode.getErrDesc();
    }

    public BusinessException(Throwable throwable, String format, Object... objects) {
        super(formatMessage(format, objects), throwable);
        this.message = formatMessage(format, objects);
    }

    public BusinessException(Throwable throwable) {
        super(throwable.getMessage(), throwable);
        this.message = throwable.getMessage();
    }

    public BusinessException(String format, Object... objects) {
        super(formatMessage(format, objects));
        this.message = formatMessage(format, objects);
    }

    private static String formatMessage(String format, Object... objects) {
        final String formatStr = StringUtils.replace(format, "{}", "%s");
        return String.format(formatStr, objects);
    }

}
