package com.xforceplus.pscc.common.intercept;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.validation.constraints.NotNull;

/**
 * 自定义输出流包装器，重写write方法，并记录保存ResponseBody
 */
public class LogServletOutputStream extends ServletOutputStream {

    private ServletOutputStream outputStream;
    private StringBuffer buffer;

    public LogServletOutputStream(ServletOutputStream outputStream) {
        this.outputStream = outputStream;
        buffer = new StringBuffer();
    }

    @Override
    public void write(int b) throws IOException {
        outputStream.write(b);
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) throws IOException {
        outputStream.write(b, off, len);
        byte[] bytes = new byte[len];
        System.arraycopy(b, off, bytes, 0, len);
        buffer.append(new String(bytes, StandardCharsets.UTF_8));
    }

    @Override
    public void write(@NotNull byte[] b) throws IOException {
        outputStream.write(b);
    }

    @Override
    public void flush() throws IOException {
        super.flush();
    }

    //清空buffer，以便下一次重新使用
    public void myFlush() {
        outputStream = null;
        buffer = null;
    }

    public String getBuffer() {
        if (buffer != null) {
            return buffer.toString();
        }
        return null;
    }

    @Override
    public boolean isReady() {
        return false;
    }

    @Override
    public void setWriteListener(WriteListener writeListener) {
    }

}