package com.xforceplus.pscc.common.intercept;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

/**
 * 该包装器主要是重写getOutputStream()和getWriter()方法，给调用者返回自定义的OutputStream和Writer，以便参与输出的过程并记录保存responseBody。
 */
public class ResponseWrapper extends HttpServletResponseWrapper {

    private ResponsePrintWriter writer;
    private LogServletOutputStream out;

    public ResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        //一定要先判断当前out为空才能去新建out对象，否则一次请求会出现多个out对象
        if (out == null) {
            out = new LogServletOutputStream(super.getOutputStream());
        }
        return out;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        //一定要先判断当前writer为空才能去新建writer对象，否则一次请求会出现多个writer对象
        if (writer == null) {
            writer = new ResponsePrintWriter(super.getWriter());
        }
        return writer;
    }

    public ResponsePrintWriter getMyWriter() {
        return writer;
    }

    public LogServletOutputStream getMyOutputStream() {
        return out;
    }

}