package com.xforceplus.pscc.common.intercept;

import cn.hutool.core.lang.UUID;
import org.slf4j.MDC;

/**
 * @description: trace context
 * @author: zhuxingsheng@gmail.com
 * @create: 2021-07-08 18:17
 */
public class TraceContext {

    public static String traceKey = "traceId";

    public static String putContextTraceId() {
        final String traceId = UUID.fastUUID().toString(true);
        MDC.put(traceKey, traceId);
        return traceId;
    }

    public static String putContextTraceId(String traceId) {
        MDC.put(traceKey, traceId);
        return traceId;
    }

    public static String getContextTraceId() {
        return MDC.get(traceKey);
    }

    public static void removeContextTraceId() {
        MDC.remove(traceKey);
    }

}
