package com.xforceplus.pscc.common.janus;

import java.util.Map;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * @Description:
 * @Author: zhujunjie
 * @Date: 2022/7/6 15:01
 */
@Data
@Configuration
@ConfigurationProperties(prefix = "pscc.common.janus")
public class JanusConfig {

    private String httpUrl;

    private String authentication;

    private String uiaSign;

    private String tcpUrl;

    private Integer tcpPort = 443;

    private String clientId;

    private String tenantId;

    private String tenantCode;

    private Map<String, ActionData> actionMap;

    @Data
    public static class ActionData {

        private String method;

        private String action;

    }

}
