package com.xforceplus.pscc.common.janus;

import com.alibaba.fastjson2.JSONObject;
import com.xforceplus.pscc.common.janus.JanusConfig.ActionData;
import java.util.Map;

/**
 * @Description:
 * @Author: zhujunjie
 * @Date: 2022/7/6 17:41
 */
public interface JanusService {

    ActionData getActionData(ActionName actionName);

    /**
     * 根据请求参数请求，serialNo为traceId
     *
     * @param actionName 请求action key
     * @param body       请求参数
     * @return 结果
     */
    JSONObject send(ActionName actionName, Map<String, Object> body);

    /**
     * 根据请求参数请求，serialNo为traceId （自定义返回类型）
     *
     * @param actionName 请求action key
     * @param body       请求参数
     * @return 结果
     */
    <T> T send(ActionName actionName, Map<String, Object> body, Class<T> tClass);

    /**
     * 根据请求参数请求，传入流水号
     *
     * @param actionName 请求action key
     * @param body       请求参数
     * @param serialNo   传入流水号
     * @return 结果
     */
    JSONObject send(ActionName actionName, Map<String, Object> body, String serialNo);

    /**
     * 根据请求参数请求，传入流水号 （自定义返回类型）
     *
     * @param actionName 请求action key
     * @param body       请求参数
     * @param serialNo   传入流水号
     * @return 结果
     */
    <T> T send(ActionName actionName, Map<String, Object> body, String serialNo, Class<T> tClass);

    /**
     * 全参数 返回JSONObject
     *
     * @param actionName 请求action key
     * @param header     请求头
     * @param param      url请求参数
     * @param body       请求体
     * @param serialNo   传入流水号
     * @return 结果 JSONObject
     */
    JSONObject send(ActionName actionName, Map<String, String> header,
        Map<String, String> param, Map<String, Object> body, String serialNo);

    /**
     * 全参数（自定义返回类型）
     *
     * @param actionName 请求action key
     * @param headerMap  请求头
     * @param param      请求参数
     * @param serialNo   传入流水号
     * @param tClass     返回类型
     * @return 结果
     */
    <T> T send(ActionName actionName, Map<String, String> headerMap,
        Map<String, String> param, Map<String, Object> body, String serialNo, Class<T> tClass);

    <T> T send(ActionName actionName, Map<String, String> headerMap,
        Map<String, String> param, String body, String serialNo, Class<T> tClass);

}
