package com.xforceplus.pscc.common.janus;

import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.pscc.common.dto.CommonResponse;

/**
 * @Description:
 * @Author: zhujunjie
 * @Date: 2022/7/7 17:59
 */
public interface MessageHandler {

    /**
     * 队列名称
     *
     * @return 队列名
     */
    String getRequestName();

    /**
     * 处理消息
     *
     * @param sealedMessage 消息
     * @return 结果
     */
    CommonResponse handle(SealedMessage sealedMessage);

    /**
     * 非必须实现 处理回执消息
     *
     * @param sealedMessage 回执消息
     */
    default void receiveReceipt(SealedMessage sealedMessage) {

    }

}
