package com.xforceplus.pscc.common.starter;

import com.xforceplus.pscc.common.bot.BotConfig;
import com.xforceplus.pscc.common.bot.BotService;
import com.xforceplus.pscc.common.bot.task.DefaultWarningImpl;
import com.xforceplus.pscc.common.bot.task.DingdingWarning;
import com.xforceplus.pscc.common.bot.task.ExceptionWarning;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @Description:
 * @Author: zhujunjie
 * @Date: 2022/7/18 10:54
 */
@Configuration
public class ExceptionWarningConfiguration {

    @Autowired
    private BotConfig botConfig;

    @Autowired
    private BotService botService;

    @Value("${spring.profiles.active:default}")
    private String env;

    @Value("${spring.application.name:default}")
    private String appName;

    @Bean
    public ExceptionWarning initializationExceptionWarning() {
        //配置钉钉token和key启用
        if (StringUtils.isNotBlank(botConfig.getDingBotToken()) && StringUtils.isNotBlank(botConfig.getDingBotKey())) {
            ScheduledExecutorService warningExecutor = new ScheduledThreadPoolExecutor(10,
                new BasicThreadFactory.Builder().namingPattern("exception-warning-pool-%d").daemon(true).build());
            return new DingdingWarning(botConfig, botService, warningExecutor, appName, env);
        } else {
            return new DefaultWarningImpl();
        }
    }


}
