package com.xforceplus.pscc.common.starter;

import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.pscc.common.bot.task.ExceptionWarning;
import com.xforceplus.pscc.common.janus.JanusConfig;
import com.xforceplus.pscc.common.janus.JanusListener;
import com.xforceplus.pscc.common.janus.MessageHandler;
import java.util.Map;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix = "pscc.common.janus", name = {"tcpUrl", "clientId"}, matchIfMissing = false)
@AllArgsConstructor
public class JanuxTcpStarterConfiguration implements ApplicationContextAware, ApplicationRunner {

    private ApplicationContext applicationContext;
    private final JanusConfig janusConfig;
    private final ExceptionWarning exceptionWarning;

    @Override
    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        MCFactory mcFactory = MCFactory.getInstance(janusConfig.getClientId(), janusConfig.getTcpUrl(), janusConfig.getTcpPort());
        JanusListener janusListener = new JanusListener(mcFactory, exceptionWarning);
        Map<String, MessageHandler> handlerMap = applicationContext.getBeansOfType(MessageHandler.class);
        if (!MapUtils.isEmpty(handlerMap)) {
            handlerMap.values().forEach(handler -> janusListener.putHandleMap(handler.getRequestName(), handler));
        }
        mcFactory.registerListener(janusListener);
    }

}
