package com.xforceplus.pscc.common.util;

import cn.hutool.core.util.URLUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSON;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Request.Builder;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author w
 */
public class OkHttpClientUtil {

    private static Logger logger = LoggerFactory.getLogger(OkHttpClientUtil.class);

    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse("application/json; charset=utf-8");

    private static OkHttpClient okHttpClient = createOkHttpClient();

    public static OkHttpClient createOkHttpClient() {
        return new OkHttpClient.Builder()
            .connectTimeout(30, TimeUnit.SECONDS)
            .readTimeout(30, TimeUnit.SECONDS)
            .build();
    }

    public static String doGet(String url) throws IOException {
        Request request = new Request.Builder()
            .get()
            .url(url)
            .build();
        return Objects.requireNonNull(okHttpClient.newCall(request).execute().body()).string();
    }

    public static String doPost(String url, Map<String, String> requestBody) throws IOException {
        FormBody.Builder formBody = new FormBody.Builder();
        if (!requestBody.isEmpty()) {
            for (String key : requestBody.keySet()) {
                formBody.add(key, requestBody.get(key));
            }
        }
        RequestBody requestBodyPost = formBody.build();
        Request request = new Request.Builder()
            .post(requestBodyPost)
            .url(url)
            .build();
        return Objects.requireNonNull(okHttpClient.newCall(request).execute().body()).string();
    }

    public static String doPost(String url, String json) throws IOException {
        RequestBody requestBody = RequestBody.create(MEDIA_TYPE_JSON, json);
        Request request = new Request.Builder()
            .post(requestBody)
            .url(url)
            .build();
        return Objects.requireNonNull(okHttpClient.newCall(request).execute().body()).string();
    }

    public static Response doGet(String url, Map<String, String> headMap, Map<String, Object> params) throws IOException {
        String paramsString = HttpUtil.toParams(params);
        Builder build = new Request.Builder();
        headMap.forEach((k, v) -> {
            //剔除为空的
            if (v != null) {
                build.addHeader(k, v);
            }
        });
        Request request = build.get()
            .url(URLUtil.normalize(StringUtils.isBlank(paramsString) ? url : url + "?" + paramsString))
            .build();
        return okHttpClient.newCall(request).execute();
    }

    public static Response doPost(String url, Map<String, String> headMap, Map<String, String> params, String json) throws IOException {
        String paramsString = HttpUtil.toParams(params);
        RequestBody requestBody = RequestBody.create(MEDIA_TYPE_JSON, json);
        Builder build = new Request.Builder().url(URLUtil.normalize(StringUtils.isBlank(paramsString) ? url : url + "?" + paramsString));
        headMap.forEach((k, v) -> {
            //剔除为空的
            if (v != null) {
                build.addHeader(k, v);
            }
        });
        Request request = build
            .post(requestBody)
            .build();
        return okHttpClient.newCall(request).execute();
    }

    public static void main(String[] args) throws IOException {

        String body = "{\"page\":{\"pageNo\":1,\"pageSize\":20},\"conditions\":[{\"conditionOP\":8,\"field\":\"dateIssued\",\"value\":\"20220628\"}],\"sorts\":[]}";

        OkHttpClient client = new OkHttpClient.Builder()
            .connectTimeout(25, TimeUnit.SECONDS)
            .readTimeout(25, TimeUnit.SECONDS)
            .build();

        Request requestBuild = new Request.Builder()
            .url("https://janus-inte.xforceplus.com")
            .addHeader("Authentication", "casstime-extend2022071317441713479905")
            .addHeader("tenant-code", "Cass")
            .addHeader("uiaSign", "8c74445a4e1a7f21375ba9d0b7cbec1d")
            .addHeader("action", "BB9376FA0A009242252A96A03CA882DF")
            .addHeader("rpcType", "http")
            .addHeader("Accept-Encoding", "deflate")
            .addHeader("serialNo", "1231243253456345435")
            .post(RequestBody.create(MediaType.parse("application/json;charset=UTF-8"), body))
            .build();

        String responseString = null;

        try {
            Response response = client.newCall(requestBuild).execute();
            responseString = response.body().string();
        } catch (IOException e) {
            logger.error("调用集成平台API异常：{}", e.getMessage());
        }
        logger.info("调用集成平台API结果：{}", responseString);

        body = "{\"clientId\":\"cassmall_sit\",\"clientSecret\":\"a04f8b89a2ee411aa44b58dbf651205d\",\"sso\":false,\"tenantCode\":\"Cass\",\"username\":\"62a98e8cfb022f0001500844@cassmall.com\"}";
        HttpRequest httpRequest = HttpUtil.createPost("https://janus-inte.xforceplus.com");
        httpRequest.header("Authentication", "casstime-extend2022071317441713479905")
            .header("tenantCode", "Cass")
            .header("uiaSign", "8c74445a4e1a7f21375ba9d0b7cbec1d")
            .header("action", "DDFB20C090D82E2483514ECE234C6EF4")
            .header("rpcType", "http")
            .header("Accept-Encoding", "deflate")
            .header("serialNo", "1231243253456345435");
        httpRequest.body(body, "application/json;charset=UTF-8");

        HttpResponse response = httpRequest.execute();

        System.out.println(JSON.toJSONString(response));
        System.out.println(JSON.toJSONString(response.body()));
    }

}
