package com.xforceplus.pscc.common.wapper;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.annotation.OqsTransactional;
import com.xforceplus.ultraman.oqsengine.sdk.util.RequestBuilder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Function;

/**
 * @Description:
 * @Author: zhujunjie
 * @Date: 2022/1/17 18:12
 */
public interface EntityMapper {

    IEntityClass getEntityClass(String entityCode);

    IEntityClass getEntityClass(EntityEnum entityEnum);

    <T> T transactionalExecute(Callable<T> callable);

    List<IEntityClass> getEntityClasss();

    Long create(EntityEnum entityEnum, Map<String, Object> entity);

    /**
     * 循环创建 保证强一致 创建后可以立刻查询
     *
     * @param entityEnum 表
     * @param entityList 参数
     * @return 数量
     */
    @OqsTransactional(rollbackFor = {Exception.class})
    Integer createLoop(EntityEnum entityEnum, List<Map<String, Object>> entityList);

    /**
     * 批量创建 未保证强一致 创建后无法立刻查询
     *
     * @param entityEnum 表
     * @param entityList 参数
     * @return 数量
     */
    Integer createMulti(EntityEnum entityEnum, List<Map<String, Object>> entityList);

    void deleteById(EntityEnum entityEnum, long id);

    Integer deleteByIds(EntityEnum entityEnum, List<Long> ids);

    Integer deleteByCondition(EntityEnum entityEnum, RequestBuilder requestBuilder);

    void updateById(EntityEnum entityEnum, long id, Map<String, Object> entity);

    /**
     * 循环更新  保证强一致 更新后可以立刻查询
     *
     * @param entityEnum 表
     * @param entity     参数
     * @return 数量
     */
    Integer updateByIds(EntityEnum entityEnum, List<Long> ids, Map<String, Object> entity);

    /**
     * 批量更新 未保证强一致 更新后无法立刻查询
     *
     * @param entityEnum 表
     * @param entityList 参数
     * @return 数量
     */
    Integer updateMulti(EntityEnum entityEnum, List<Map<String, Object>> entityList);

    /**
     * 根据条件更新  保证强一致 更新后可以立刻查询
     *
     * @param entityEnum 表
     * @param entity     参数
     * @return 数量
     */
    Integer updateByCondition(EntityEnum entityEnum, RequestBuilder requestBuilder, Map<String, Object> entity);

    Integer replaceById(EntityEnum entityEnum, long id, Map<String, Object> entity);

    Map<String, Object> findOne(EntityEnum entityEnum, long id);

    <T> T findOne(EntityEnum entityEnum, long id, Function<Map<String, Object>, T> toEntityFunction);

    List<Map<String, Object>> findByIds(EntityEnum entityEnum, List<Long> ids);

    <T> List<T> findByIds(EntityEnum entityEnum, List<Long> ids, Function<Map<String, Object>, T> toEntityFunction);

    Long count(EntityEnum entityEnum, RequestBuilder requestBuilder);

    List<Map<String, Object>> findByCondition(EntityEnum entityEnum, Map<String, Object> entityMap);

    List<Map<String, Object>> findByCondition(EntityEnum entityEnum, RequestBuilder requestBuilder);

    List<Long> findIdsByCondition(EntityEnum entityEnum, RequestBuilder requestBuilder);

    <T> List<T> findByCondition(EntityEnum entityEnum, RequestBuilder requestBuilder, Function<Map<String, Object>, T> toEntityFunction);

    <T> T findOneByCondition(EntityEnum entityEnum, RequestBuilder requestBuilder, Function<Map<String, Object>, T> toEntityFunction);

}
