/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.pscc.common.bot.task;

import com.xforceplus.pscc.common.bot.BotConfig;
import com.xforceplus.pscc.common.bot.BotService;
import com.xforceplus.pscc.common.bot.task.ExceptionWarning;
import com.xforceplus.pscc.common.intercept.TraceContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingdingWarning
implements ExceptionWarning {
    private static final Logger log = LoggerFactory.getLogger(DingdingWarning.class);
    private static final Map<Object, Integer> countMap = new ConcurrentHashMap<Object, Integer>();
    private static final AtomicInteger countAll = new AtomicInteger(0);
    private Long timePoint = System.currentTimeMillis();
    private BotConfig botConfig;
    private BotService botService;
    private ExecutorService executorService;
    private String appName;
    private String env;
    private String ip;

    public DingdingWarning(BotConfig botConfig, BotService botService, ExecutorService executorService, String appName, String env) {
        this.botConfig = botConfig;
        this.botService = botService;
        this.executorService = executorService;
        this.appName = appName;
        this.env = env;
        try {
            this.ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            this.ip = "\u672a\u77e5";
            e.printStackTrace();
        }
    }

    @Override
    public void httpWarn(Exception e, HttpServletRequest request) {
        String traceId = TraceContext.getContextTraceId();
        this.executorService.submit(() -> {
            try {
                if (!this.needWarn(e)) {
                    return;
                }
                this.botService.sendInfo(String.format("traceId: %s\nappName: %s\nip: %s\nrequestURI: %s\nmethodName: %s\nenv: %s\nexceptionMessage: %s", traceId, this.appName, this.ip, request.getRequestURI(), request.getMethod(), this.env, this.getStackTraceString(e)));
            }
            catch (Exception ecp) {
                log.error("\u9489\u9489\u673a\u5668\u4eba\u8ba1\u6570\u544a\u8b66\u9519\u8bef\uff1a{}", (Object)ecp.getMessage());
            }
        });
    }

    @Override
    public void januxWarn(Exception e, String requestName) {
        String traceId = TraceContext.getContextTraceId();
        this.executorService.submit(() -> {
            try {
                if (!this.needWarn(e)) {
                    return;
                }
                this.botService.sendInfo(String.format("traceId: %s\nappName: %s\nip: %s\nrequestURI: %s\nmethodName: %s\nenv: %s\nexceptionMessage: %s", traceId, this.appName, this.ip, requestName, "Janus", this.env, this.getStackTraceString(e)));
            }
            catch (Exception ecp) {
                log.error("\u9489\u9489\u673a\u5668\u4eba\u8ba1\u6570\u544a\u8b66\u9519\u8bef\uff1a{}", (Object)ecp.getMessage());
            }
        });
    }

    private boolean needWarn(Exception e) {
        boolean needWarn = false;
        String errClz = e.getClass().toString();
        if (this.botConfig.getWarningType().equals(0)) {
            needWarn = this.countAll(2);
        } else if (this.botConfig.getWarningType().equals(1)) {
            needWarn = this.countAll(10) && this.countOne(errClz);
        }
        return needWarn;
    }

    private boolean countAll(Integer count) {
        Integer n = count = this.botConfig.getWarningCountThres() == null ? count : this.botConfig.getWarningCountThres();
        if ((System.currentTimeMillis() - this.timePoint) / 60000L < (long)this.botConfig.getWarningMinutesThres().intValue()) {
            if (countAll.get() < count) {
                countAll.addAndGet(1);
                return true;
            }
            return false;
        }
        this.timePoint = System.currentTimeMillis();
        countAll.set(1);
        countMap.clear();
        return true;
    }

    @Override
    public void exceptionWarn(Exception e, String bussinessInfo) {
        String traceId = TraceContext.getContextTraceId();
        this.executorService.submit(() -> {
            try {
                if (!this.needWarn(e)) {
                    return;
                }
                this.botService.sendInfo(String.format("traceId: %s\nappName: %s\nip: %s\nbussinessInfo: %s\nmethodName: %s\nenv: %s\nexceptionMessage: %s", traceId, this.appName, this.ip, bussinessInfo, "method", this.env, this.getStackTraceString(e)));
            }
            catch (Exception ecp) {
                log.error("\u9489\u9489\u673a\u5668\u4eba\u8ba1\u6570\u544a\u8b66\u9519\u8bef\uff1a{}", (Object)ecp.getMessage());
            }
        });
    }

    private boolean countOne(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            key = "\u672a\u77e5\u5f02\u5e38";
        }
        int count = countMap.get(key) != null ? countMap.get(key) + 1 : 1;
        countMap.put(key, count);
        if (count <= this.botConfig.getWarningCountThresByOne()) {
            return true;
        }
        countAll.addAndGet(-1);
        return false;
    }

    private String getStackTraceString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter((Writer)sw, true));
        String stack = sw.toString();
        stack = stack.length() >= this.botConfig.getLimitChars() ? stack.substring(0, this.botConfig.getLimitChars()) + "..." : stack;
        return stack;
    }
}

