/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.pscc.common.intercept;

import cn.hutool.core.collection.CollUtil;
import com.xforceplus.pscc.common.intercept.LogFilterConfig;
import com.xforceplus.pscc.common.intercept.RequestWrapper;
import com.xforceplus.pscc.common.intercept.ResponseWrapper;
import com.xforceplus.pscc.common.intercept.TraceContext;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;

@Component
@WebFilter(filterName="logFilter", urlPatterns={"/*"})
public class LogFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(LogFilter.class);
    @Autowired
    private LogFilterConfig logFilterConfig;
    private static final Set<String> EXCLUDE_PATTERNS = CollUtil.newHashSet((Object[])new String[]{"health", "data-om", "bos"});
    private static final String CONTENT_TYPE = "application/json";

    @PostConstruct
    public void beanPost() {
        if (CollectionUtils.isEmpty(this.logFilterConfig.getExcludePath())) {
            return;
        }
        EXCLUDE_PATTERNS.addAll(this.logFilterConfig.getExcludePath());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (LogFilter.isExcludePattern(httpServletRequest.getRequestURI())) {
            TraceContext.putContextTraceId();
            chain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            TraceContext.removeContextTraceId();
            return;
        }
        httpServletRequest = this.logRequest(httpServletRequest);
        ResponseWrapper responseWrapper = new ResponseWrapper(httpServletResponse);
        Long dateStart = System.currentTimeMillis();
        chain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)responseWrapper);
        this.logResponse(dateStart, responseWrapper);
    }

    public HttpServletRequest logRequest(HttpServletRequest httpServletRequest) {
        try {
            String paramBody = null;
            if (StringUtils.contains((CharSequence)httpServletRequest.getContentType(), (CharSequence)CONTENT_TYPE)) {
                httpServletRequest = new RequestWrapper((HttpServletRequest)httpServletRequest);
                paramBody = LogFilter.getRequestParamBody(httpServletRequest);
            }
            String uri = httpServletRequest.getRequestURI();
            String method = httpServletRequest.getMethod();
            String requestedIp = LogFilter.getRealIP(httpServletRequest);
            log.info("\u8bf7\u6c42\u62a5\u6587-TraceId:{},Method:{},Uri:{},PathVariable:{},Ip:{},RequestStr:{}", new Object[]{TraceContext.putContextTraceId(), method, uri, httpServletRequest.getQueryString(), requestedIp, paramBody});
        }
        catch (Exception e) {
            log.error("\u8f93\u51fa\u8bf7\u6c42\u62a5\u6587\u5f02\u5e38-->", (Throwable)e);
        }
        return httpServletRequest;
    }

    public void logResponse(Long dateStart, ResponseWrapper responseWrapper) {
        try {
            if (!StringUtils.contains((CharSequence)responseWrapper.getContentType(), (CharSequence)CONTENT_TYPE)) {
                log.info("response contentType:{}\uff0c\u65e0\u9700\u6253\u5370\u53c2\u6570", (Object)responseWrapper.getContentType());
            } else {
                Long dateEnd = System.currentTimeMillis();
                String responseBody = null;
                if (responseWrapper.getMyOutputStream() == null) {
                    if (responseWrapper.getMyWriter() != null) {
                        responseBody = responseWrapper.getMyWriter().getContent();
                        responseWrapper.getMyWriter().myFlush();
                    }
                } else {
                    responseBody = responseWrapper.getMyOutputStream().getBuffer();
                    responseWrapper.getMyOutputStream().myFlush();
                }
                log.info("\u8fd4\u56de\u62a5\u6587-TraceId:{},Time:{},ResponseStr:{}", new Object[]{TraceContext.getContextTraceId(), dateEnd - dateStart, responseBody});
            }
            TraceContext.removeContextTraceId();
        }
        catch (Exception e) {
            log.error("\u8f93\u51fa\u8fd4\u56de\u62a5\u6587\u5f02\u5e38-->", (Throwable)e);
        }
    }

    public Map<String, String> getHeaders(HttpServletRequest request) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        List<String> headers = this.getCommonHeaders();
        headers.add("Postman-Token");
        headers.add("Proxy-Connection");
        headers.add("X-Lantern-Version");
        headers.add("Cookie");
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (headers.contains(headerName)) continue;
            headerMap.put(headerName, request.getHeader(headerName));
        }
        return headerMap;
    }

    private List<String> getCommonHeaders() {
        Field[] fields;
        ArrayList<String> headers = new ArrayList<String>();
        Class<HttpHeaders> clazz = HttpHeaders.class;
        for (Field field : fields = clazz.getFields()) {
            field.setAccessible(true);
            if (!field.getType().toString().endsWith("java.lang.String") || !Modifier.isStatic(field.getModifiers())) continue;
            try {
                headers.add((String)field.get(HttpHeaders.class));
            }
            catch (IllegalAccessException e) {
                log.error("\u53cd\u5c04\u83b7\u53d6\u5c5e\u6027\u503c\u5f02\u5e38-->", (Throwable)e);
            }
        }
        return headers;
    }

    public static String getRealIP(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (StringUtils.isNotEmpty((CharSequence)ip) && !"unKnown".equalsIgnoreCase(ip)) {
            int index = ip.indexOf(",");
            if (index != -1) {
                return ip.substring(0, index);
            }
            return ip;
        }
        ip = request.getHeader("X-Real-IP");
        if (StringUtils.isNotEmpty((CharSequence)ip) && !"unKnown".equalsIgnoreCase(ip)) {
            return ip;
        }
        return request.getRemoteAddr();
    }

    public static String getRequestParamBody(HttpServletRequest request) throws IOException {
        String requestBody = null;
        if (!(request instanceof RequestWrapper)) {
            return requestBody;
        }
        return ((RequestWrapper)request).getBody();
    }

    public static boolean isExcludePattern(String url) {
        boolean match;
        if (StringUtils.isBlank((CharSequence)url)) {
            return false;
        }
        String path = url.trim();
        if (StringUtils.startsWith((CharSequence)path, (CharSequence)"/")) {
            path = StringUtils.substring((String)path, (int)1);
        }
        if (match = EXCLUDE_PATTERNS.stream().anyMatch(path::startsWith)) {
            // empty if block
        }
        return match;
    }

    public void init(FilterConfig logFilterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

