/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.pscc.common.intercept;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.validation.constraints.NotNull;

public class LogServletOutputStream
extends ServletOutputStream {
    private ServletOutputStream outputStream;
    private StringBuffer buffer;

    public LogServletOutputStream(ServletOutputStream outputStream) {
        this.outputStream = outputStream;
        this.buffer = new StringBuffer();
    }

    public void write(int b) throws IOException {
        this.outputStream.write(b);
    }

    public void write(@NotNull byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
        byte[] bytes = new byte[len];
        System.arraycopy(b, off, bytes, 0, len);
        this.buffer.append(new String(bytes, StandardCharsets.UTF_8));
    }

    public void write(@NotNull byte[] b) throws IOException {
        this.outputStream.write(b);
    }

    public void flush() throws IOException {
        super.flush();
    }

    public void myFlush() {
        this.outputStream = null;
        this.buffer = null;
    }

    public String getBuffer() {
        if (this.buffer != null) {
            return this.buffer.toString();
        }
        return null;
    }

    public boolean isReady() {
        return false;
    }

    public void setWriteListener(WriteListener writeListener) {
    }
}

