/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.pscc.common.janus;

import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.apollo.client.utils.SealedMessageBuilder;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.janus.framework.event.AckTuple;
import com.xforceplus.janus.framework.event.ISealedMessageEventListener;
import com.xforceplus.janus.framework.event.SealedMessageEvent;
import com.xforceplus.pscc.common.bot.task.ExceptionWarning;
import com.xforceplus.pscc.common.exception.BusinessException;
import com.xforceplus.pscc.common.exception.JanusFaultException;
import com.xforceplus.pscc.common.intercept.TraceContext;
import com.xforceplus.pscc.common.starter.ThreadPoolConfiguration;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractJanusListener
implements ISealedMessageEventListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractJanusListener.class);
    @Autowired
    ThreadPoolConfiguration threadPoolConfiguration;
    @Autowired
    private ExceptionWarning exceptionWarning;

    public abstract String handle(SealedMessage var1);

    private String handleAsync(SealedMessage sealedMessage, String msgId) {
        this.threadPoolConfiguration.getJanusThreadPool().execute(() -> {
            SealedMessage receipt;
            String businessNo = (String)sealedMessage.getHeader().getOthers().get("businessNo");
            String requestName = sealedMessage.getHeader().getRequestName();
            String traceId = TraceContext.putContextTraceId(msgId);
            try {
                String responseMsg = this.handle(sealedMessage);
                receipt = SealedMessageBuilder.buildReceiptMessage((SealedMessage)sealedMessage, (boolean)true, (String)responseMsg);
            }
            catch (JanusFaultException jfe) {
                log.info("\u96c6\u6210\u5e73\u53f0\u6d88\u606f\u5f02\u6b65\u5904\u7406\u5f02\u5e38\uff01{}", (Object)jfe.getMessage());
                this.exceptionWarning.januxWarn(jfe, requestName);
                receipt = SealedMessageBuilder.buildReceiptMessage((SealedMessage)sealedMessage, (boolean)false, (String)jfe.getMessage());
            }
            catch (BusinessException be) {
                log.info("\u96c6\u6210\u5e73\u53f0\u6d88\u606f\u5904\u7406\u4e2d\u6b62\uff01{}", (Object)be.getMessage());
                receipt = SealedMessageBuilder.buildReceiptMessage((SealedMessage)sealedMessage, (boolean)true, (String)be.getMessage());
            }
            catch (Exception ex) {
                log.error("\u96c6\u6210\u5e73\u53f0\u6d88\u606f\u5f02\u6b65\u5904\u7406\u5f02\u5e38\uff01", (Throwable)ex);
                this.exceptionWarning.januxWarn(ex, requestName);
                receipt = SealedMessageBuilder.buildReceiptMessage((SealedMessage)sealedMessage, (boolean)true, (String)(traceId + ":" + ex.getMessage()));
            }
            receipt.getHeader().getOthers().put("businessNo", businessNo);
            try {
                MCFactory.getInstance().sendMessage(receipt);
            }
            catch (Exception e) {
                log.error("\u96c6\u6210\u5e73\u53f0\u6d88\u606f\u5f02\u6b65\u6267\u884c--\u56de\u6267\u53d1\u9001\u5f02\u5e38\uff01" + requestName, (Throwable)e);
            }
            TraceContext.removeContextTraceId();
        });
        return "\u5f02\u6b65\u6267\u884c\u5df2\u63d0\u4ea4";
    }

    public AckTuple<Boolean, String> onEvent(SealedMessageEvent sealedMessageEvent) {
        AckTuple ackTuple;
        SealedMessage sealedMessage = sealedMessageEvent.getSealedMessage();
        SealedMessage.Header header = sealedMessage.getHeader();
        String playLoadId = header.getPayLoadId();
        String msgId = header.getMsgId();
        String requestName = header.getRequestName();
        String traceId = TraceContext.putContextTraceId(msgId);
        try {
            String body = sealedMessage.getPayload().getObj().toString();
            log.info("\u6d88\u606f\u961f\u5217\u76d1\u542c\u5668\u63a5\u6536\u5230\u3010{}\u3011\u961f\u5217,payLoadId\u3010{}\u3011,msgId\u3010{}\u3011", new Object[]{requestName, playLoadId, msgId});
            log.info("\u6d88\u606f\u5185\u5bb9\uff1a{}", (Object)body);
            String result = this.threadPoolConfiguration.getJanusThreadPoolEnable() != false ? this.handleAsync(sealedMessage, msgId) : this.handle(sealedMessage);
            ackTuple = new AckTuple((Object)true, (Object)result);
        }
        catch (JanusFaultException jfe) {
            log.info("\u96c6\u6210\u5e73\u53f0\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01{}", (Object)jfe.getMessage());
            this.exceptionWarning.januxWarn(jfe, requestName);
            ackTuple = new AckTuple((Object)false, (Object)jfe.getMessage());
        }
        catch (RejectedExecutionException ree) {
            log.info("\u96c6\u6210\u5e73\u53f0\u6d88\u606f\u5904\u7406\u79ef\u538b\uff01{}", (Object)ree.getMessage());
            this.exceptionWarning.exceptionWarn(ree, "\u5f02\u6b65\u6d88\u606f\u5df2\u79ef\u538b");
            ackTuple = new AckTuple((Object)false, (Object)"\u5f02\u6b65\u6d88\u606f\u5df2\u79ef\u538b");
        }
        catch (BusinessException be) {
            log.info("\u96c6\u6210\u5e73\u53f0\u6d88\u606f\u5904\u7406\u5b8c\u6bd5\uff01{}", (Object)be.getMessage());
            ackTuple = new AckTuple((Object)true, (Object)be.getMessage());
        }
        catch (Exception ex) {
            log.error("\u96c6\u6210\u5e73\u53f0\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff01" + requestName, (Throwable)ex);
            this.exceptionWarning.januxWarn(ex, requestName);
            ackTuple = new AckTuple((Object)true, (Object)(traceId + ":" + ex.getMessage()));
        }
        TraceContext.removeContextTraceId();
        return ackTuple;
    }
}

