/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.pscc.common.janus;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.google.common.collect.Maps;
import com.xforceplus.pscc.common.exception.ApplicationException;
import com.xforceplus.pscc.common.intercept.TraceContext;
import com.xforceplus.pscc.common.janus.ActionName;
import com.xforceplus.pscc.common.janus.JanusConfig;
import com.xforceplus.pscc.common.janus.JanusService;
import com.xforceplus.pscc.common.util.OkHttpClientUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import okhttp3.Response;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class JanusServiceImpl
implements JanusService {
    private static final Logger log = LoggerFactory.getLogger(JanusServiceImpl.class);
    private static final String PREFIX = "pscc.common.janus";
    private final JanusConfig janusConfig;

    @Override
    public JanusConfig.ActionData getActionData(ActionName actionName) {
        if (MapUtils.isEmpty(this.janusConfig.getActionMap())) {
            throw new ApplicationException("\u672a\u914d\u7f6e\u53c2\u6570:\u96c6\u6210\u5e73\u53f0action,\u914d\u7f6eprefix:pscc.common.janus.actionMap");
        }
        JanusConfig.ActionData actionData = this.janusConfig.getActionMap().get(actionName.getKey());
        if (actionData == null) {
            throw new ApplicationException("\u672a\u627e\u5230\u5bf9\u5e94action,key:{},name:{}", actionName.getKey(), actionName.getName());
        }
        return actionData;
    }

    @Override
    public JSONObject send(ActionName actionName, Map<String, Object> body) {
        JanusConfig.ActionData actionData = this.getActionData(actionName);
        return this.send(actionData, actionName, null, null, JSON.toJSONString(body), TraceContext.getContextTraceId(), JSONObject.class);
    }

    @Override
    public <T> T send(ActionName actionName, Map<String, Object> body, Class<T> tClass) {
        JanusConfig.ActionData actionData = this.getActionData(actionName);
        return this.send(actionData, actionName, null, null, JSON.toJSONString(body), TraceContext.getContextTraceId(), tClass);
    }

    @Override
    public JSONObject send(ActionName actionName, Map<String, Object> body, String serialNo) {
        JanusConfig.ActionData actionData = this.getActionData(actionName);
        return this.send(actionData, actionName, null, null, JSON.toJSONString(body), serialNo, JSONObject.class);
    }

    @Override
    public <T> T send(ActionName actionName, Map<String, Object> body, String serialNo, Class<T> tClass) {
        JanusConfig.ActionData actionData = this.getActionData(actionName);
        return this.send(actionData, actionName, null, null, JSON.toJSONString(body), serialNo, tClass);
    }

    @Override
    public JSONObject send(ActionName actionName, Map<String, String> header, Map<String, String> param, Map<String, Object> body, String serialNo) {
        JanusConfig.ActionData actionData = this.getActionData(actionName);
        return this.send(actionData, actionName, header, param, JSON.toJSONString(body), serialNo, JSONObject.class);
    }

    @Override
    public <T> T send(ActionName actionName, Map<String, String> headerMap, Map<String, String> param, Map<String, Object> body, String serialNo, Class<T> tClass) {
        JanusConfig.ActionData actionData = this.getActionData(actionName);
        return this.send(actionData, actionName, headerMap, param, JSON.toJSONString(body), serialNo, tClass);
    }

    @Override
    public <T> T send(ActionName actionName, Map<String, String> headerMap, Map<String, String> param, String body, String serialNo, Class<T> tClass) {
        JanusConfig.ActionData actionData = this.getActionData(actionName);
        return this.send(actionData, actionName, headerMap, param, body, serialNo, tClass);
    }

    private <T> T send(JanusConfig.ActionData actionData, ActionName actionName, Map<String, String> header, Map<String, String> param, String body, String serialNo, Class<T> tClass) {
        this.check();
        Map<String, String> headerMap = header;
        String url = this.janusConfig.getHttpUrl();
        try {
            Response resp;
            if (CollectionUtils.isEmpty(header)) {
                headerMap = new HashMap<String, String>();
            }
            headerMap.put("rpcType", "http");
            headerMap.put("Authentication", this.janusConfig.getAuthentication());
            headerMap.put("action", actionData.getAction());
            headerMap.put("Accept-Encoding", "deflate");
            serialNo = StringUtils.isBlank((CharSequence)serialNo) ? UUID.randomUUID().toString() : serialNo;
            headerMap.put("serialNo", serialNo);
            if (StringUtils.isBlank((CharSequence)headerMap.get("tenantId"))) {
                headerMap.put("tenantId", this.janusConfig.getTenantId());
            }
            if (StringUtils.isBlank((CharSequence)headerMap.get("tenantCode"))) {
                headerMap.put("tenantCode", this.janusConfig.getTenantCode());
            }
            if (StringUtils.isBlank((CharSequence)headerMap.get("uiaSign"))) {
                headerMap.put("uiaSign", this.janusConfig.getUiaSign());
            }
            log.info("\u8c03\u7528\u96c6\u6210\u5e73\u53f0\u63a5\u53e3 serialNo:[{}] ,\u8c03\u7528\u5730\u5740:[{}],\u8c03\u7528\u65b9\u6cd5\u540d:[{}],\u53c2\u6570:{},header:{}", new Object[]{serialNo, url, actionName.getName(), body, headerMap});
            HashSet<String> keySet = new HashSet<String>(headerMap.keySet());
            for (String key : keySet) {
                if (headerMap.get(key) != null) continue;
                headerMap.remove(key);
            }
            if (StringUtils.equals((CharSequence)"get", (CharSequence)actionData.getMethod())) {
                HashMap bodyMap = Maps.newHashMap();
                if (StringUtils.isNotBlank((CharSequence)body)) {
                    if (!JSON.isValid((String)body)) {
                        throw new ApplicationException("\u683c\u5f0f\u9519\u8bef\uff01\u8bf7\u4f20\u5165\u6b63\u786e\u5f97\u6d88\u606f\u4f53,body:" + body);
                    }
                    bodyMap = JSON.parseObject((String)body);
                }
                if (MapUtils.isNotEmpty(param)) {
                    bodyMap.putAll(param);
                }
                resp = OkHttpClientUtil.doGet(this.janusConfig.getHttpUrl(), headerMap, bodyMap);
            } else {
                resp = OkHttpClientUtil.doPost(this.janusConfig.getHttpUrl(), headerMap, param, body);
            }
            if (resp.body() == null) {
                throw new ApplicationException("\u8fd4\u56de\u503c\u4e3a\u7a7a");
            }
            String message = resp.body().string();
            if (StringUtils.isBlank((CharSequence)message)) {
                throw new ApplicationException("\u8fd4\u56de\u503c\u4e3a\u7a7a");
            }
            if (!resp.isSuccessful()) {
                throw new ApplicationException("\u8fd4\u56de\u5931\u8d25!\u8fd4\u56de\u7801:{},message:{}", resp.code(), message);
            }
            log.info("\u8c03\u7528\u96c6\u6210\u5e73\u53f0\u63a5\u53e3\u6210\u529f serialNo:[{}] ,\u8c03\u7528\u5730\u5740:[{}],\u8c03\u7528\u65b9\u6cd5\u540d:[{}],\u8fd4\u56de\u503c:{}", new Object[]{serialNo, url, actionName.getName(), message});
            return (T)JSONObject.parseObject((String)message, tClass);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u96c6\u6210\u5e73\u53f0\u63a5\u53e3\u5931\u8d25 serialNo:[{}] ,\u8c03\u7528\u5730\u5740:[{}],\u8c03\u7528\u65b9\u6cd5\u540d:[{}],\u9519\u8bef\u539f\u56e0:{}", new Object[]{serialNo, url, actionName.getName(), e.getMessage()});
            throw new ApplicationException(e);
        }
    }

    private void check() {
        if (StringUtils.isBlank((CharSequence)this.janusConfig.getHttpUrl())) {
            throw new ApplicationException("\u672a\u914d\u7f6e\u53c2\u6570:\u96c6\u6210\u5e73\u53f0url,\u914d\u7f6eprefix:pscc.common.janus.httpUrl");
        }
        if (StringUtils.isBlank((CharSequence)this.janusConfig.getAuthentication())) {
            throw new ApplicationException("\u672a\u914d\u7f6e\u53c2\u6570:\u96c6\u6210\u5e73\u53f0authentication,\u914d\u7f6eprefix:pscc.common.janus.authentication");
        }
    }

    public static void main(String[] args) {
        String a = "{";
        System.out.println(JSON.isValid((String)a));
    }

    public JanusServiceImpl(JanusConfig janusConfig) {
        this.janusConfig = janusConfig;
    }
}

