/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.pscc.common.starter;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ThreadPoolConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolConfiguration.class);
    @Value(value="${pscc.common.thread.janusThreadPoolSize:0}")
    private int maxJanusThreadPoolSize;
    private Boolean janusThreadPoolEnable;
    private ExecutorService janusThreadPool;

    @PostConstruct
    public void initThreadPoolConfig() {
        int processors = Runtime.getRuntime().availableProcessors();
        int num = processors * 2;
        log.info("\u53ef\u7528\u6838\u5fc3\u6570\uff1a{}\uff0c\u6838\u5fc3\u7ebf\u7a0b\u6c60\u9ed8\u8ba4\u5927\u5c0f\uff1a{}", (Object)processors, (Object)num);
        if (this.maxJanusThreadPoolSize != 0) {
            int coreJanusThreadPoolSize = Math.min(num, this.maxJanusThreadPoolSize);
            log.info("\u96c6\u6210\u6d88\u606f\u5904\u7406\u7ebf\u7a0b\u6c60\u5927\u5c0f\uff1acore--{} max--{}", (Object)coreJanusThreadPoolSize, (Object)this.maxJanusThreadPoolSize);
            this.janusThreadPool = this.buildThreadPool(coreJanusThreadPoolSize, this.maxJanusThreadPoolSize, 10000, "janusTcp", false);
            this.janusThreadPoolEnable = true;
        } else {
            log.info("\u96c6\u6210\u6d88\u606f\u5904\u7406\u7ebf\u7a0b\u6c60\u672a\u542f\u7528\uff01");
            this.janusThreadPoolEnable = false;
        }
    }

    public ExecutorService buildThreadPool(int coreWorker, int maxWorker, int queue, String namePrefix, boolean daemon) {
        return new ThreadPoolExecutor(coreWorker, maxWorker, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(queue), ThreadPoolConfiguration.buildNameThreadFactory(namePrefix, daemon), new ThreadPoolExecutor.AbortPolicy());
    }

    public static ThreadFactory buildNameThreadFactory(final String name, final boolean daemon) {
        return new ThreadFactory(){
            private final AtomicLong number = new AtomicLong();

            @Override
            public Thread newThread(Runnable r) {
                Thread newThread = Executors.defaultThreadFactory().newThread(new MDCRunnable(r, MDC.get((String)"traceId")));
                newThread.setName(name + "-" + this.number.getAndIncrement());
                newThread.setDaemon(daemon);
                return newThread;
            }
        };
    }

    public int getMaxJanusThreadPoolSize() {
        return this.maxJanusThreadPoolSize;
    }

    public Boolean getJanusThreadPoolEnable() {
        return this.janusThreadPoolEnable;
    }

    public ExecutorService getJanusThreadPool() {
        return this.janusThreadPool;
    }

    public void setMaxJanusThreadPoolSize(int maxJanusThreadPoolSize) {
        this.maxJanusThreadPoolSize = maxJanusThreadPoolSize;
    }

    public void setJanusThreadPoolEnable(Boolean janusThreadPoolEnable) {
        this.janusThreadPoolEnable = janusThreadPoolEnable;
    }

    public void setJanusThreadPool(ExecutorService janusThreadPool) {
        this.janusThreadPool = janusThreadPool;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadPoolConfiguration)) {
            return false;
        }
        ThreadPoolConfiguration other = (ThreadPoolConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxJanusThreadPoolSize() != other.getMaxJanusThreadPoolSize()) {
            return false;
        }
        Boolean this$janusThreadPoolEnable = this.getJanusThreadPoolEnable();
        Boolean other$janusThreadPoolEnable = other.getJanusThreadPoolEnable();
        if (this$janusThreadPoolEnable == null ? other$janusThreadPoolEnable != null : !((Object)this$janusThreadPoolEnable).equals(other$janusThreadPoolEnable)) {
            return false;
        }
        ExecutorService this$janusThreadPool = this.getJanusThreadPool();
        ExecutorService other$janusThreadPool = other.getJanusThreadPool();
        return !(this$janusThreadPool == null ? other$janusThreadPool != null : !this$janusThreadPool.equals(other$janusThreadPool));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThreadPoolConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxJanusThreadPoolSize();
        Boolean $janusThreadPoolEnable = this.getJanusThreadPoolEnable();
        result = result * 59 + ($janusThreadPoolEnable == null ? 43 : ((Object)$janusThreadPoolEnable).hashCode());
        ExecutorService $janusThreadPool = this.getJanusThreadPool();
        result = result * 59 + ($janusThreadPool == null ? 43 : $janusThreadPool.hashCode());
        return result;
    }

    public String toString() {
        return "ThreadPoolConfiguration(maxJanusThreadPoolSize=" + this.getMaxJanusThreadPoolSize() + ", janusThreadPoolEnable=" + this.getJanusThreadPoolEnable() + ", janusThreadPool=" + this.getJanusThreadPool() + ")";
    }

    public static class MDCRunnable
    implements Runnable {
        private final Runnable runnable;
        private final String traceId;

        public MDCRunnable(Runnable runnable, String traceId) {
            this.runnable = runnable;
            this.traceId = traceId;
        }

        @Override
        public void run() {
            try {
                String threadTraceId = String.format("%s-%s", this.traceId, Thread.currentThread().getId());
                MDC.put((String)"traceId", (String)threadTraceId);
                this.runnable.run();
            }
            finally {
                MDC.remove((String)"traceId");
            }
        }
    }
}

