/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.pscc.common.util;

import cn.hutool.core.util.URLUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.TypeReference;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpClientUtil {
    private static Logger logger = LoggerFactory.getLogger(OkHttpClientUtil.class);
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static OkHttpClient okHttpClient = OkHttpClientUtil.createOkHttpClient();

    public static OkHttpClient createOkHttpClient() {
        return new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
    }

    public static String doGet(String url) throws IOException {
        Request request = new Request.Builder().get().url(url).build();
        return Objects.requireNonNull(okHttpClient.newCall(request).execute().body()).string();
    }

    public static String doPost(String url, Map<String, String> requestBody) throws IOException {
        FormBody.Builder formBody = new FormBody.Builder();
        if (!requestBody.isEmpty()) {
            for (String key : requestBody.keySet()) {
                formBody.add(key, requestBody.get(key));
            }
        }
        FormBody requestBodyPost = formBody.build();
        Request request = new Request.Builder().post((RequestBody)requestBodyPost).url(url).build();
        return Objects.requireNonNull(okHttpClient.newCall(request).execute().body()).string();
    }

    public static String doPost(String url, String json) throws IOException {
        RequestBody requestBody = RequestBody.create((String)json, (MediaType)MEDIA_TYPE_JSON);
        Request request = new Request.Builder().post(requestBody).url(url).build();
        return Objects.requireNonNull(okHttpClient.newCall(request).execute().body()).string();
    }

    public static Response doGet(String url, Map<String, String> headMap, Map<String, Object> params) throws IOException {
        String paramsString = HttpUtil.toParams(params);
        Request.Builder build = new Request.Builder();
        if (MapUtils.isNotEmpty(headMap)) {
            headMap.forEach((k, v) -> {
                if (v != null) {
                    build.addHeader(k, v);
                }
            });
        }
        Request request = build.get().url(URLUtil.normalize((String)(StringUtils.isBlank((CharSequence)paramsString) ? url : url + "?" + paramsString))).build();
        return okHttpClient.newCall(request).execute();
    }

    public static Response doPost(String url, Map<String, String> headMap, Map<String, String> params, String json) throws IOException {
        String paramsString = HttpUtil.toParams(params);
        RequestBody requestBody = RequestBody.create((String)json, (MediaType)MEDIA_TYPE_JSON);
        Request.Builder build = new Request.Builder().url(URLUtil.normalize((String)(StringUtils.isBlank((CharSequence)paramsString) ? url : url + "?" + paramsString)));
        if (MapUtils.isNotEmpty(headMap)) {
            headMap.forEach((k, v) -> {
                if (v != null) {
                    build.addHeader(k, v);
                }
            });
        }
        Request request = build.post(requestBody).build();
        return okHttpClient.newCall(request).execute();
    }

    public static Response doFormPost(String url, Map<String, String> headMap, Map<String, String> params, Map<String, String> body) throws IOException {
        String paramsString = HttpUtil.toParams(params);
        FormBody.Builder builder = new FormBody.Builder();
        body.forEach((k, v) -> {
            if (v != null) {
                builder.add(k, v);
            }
        });
        FormBody formBody = builder.build();
        Request.Builder build = new Request.Builder().url(URLUtil.normalize((String)(StringUtils.isBlank((CharSequence)paramsString) ? url : url + "?" + paramsString)));
        if (MapUtils.isNotEmpty(headMap)) {
            headMap.forEach((k, v) -> {
                if (v != null) {
                    build.addHeader(k, v);
                }
            });
        }
        Request request = build.post((RequestBody)formBody).build();
        return okHttpClient.newCall(request).execute();
    }

    public static void main1(String[] args) throws IOException {
        String body = "{\"page\":{\"pageNo\":1,\"pageSize\":20},\"conditions\":[{\"conditionOP\":8,\"field\":\"dateIssued\",\"value\":\"20220628\"}],\"sorts\":[]}";
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout(25L, TimeUnit.SECONDS).readTimeout(25L, TimeUnit.SECONDS).build();
        Request requestBuild = new Request.Builder().url("https://janus-inte.xforceplus.com").addHeader("Authentication", "casstime-extend2022071317441713479905").addHeader("tenant-code", "Cass").addHeader("uiaSign", "8c74445a4e1a7f21375ba9d0b7cbec1d").addHeader("action", "BB9376FA0A009242252A96A03CA882DF").addHeader("rpcType", "http").addHeader("Accept-Encoding", "deflate").addHeader("serialNo", "1231243253456345435").post(RequestBody.create((MediaType)MediaType.parse((String)"application/json;charset=UTF-8"), (String)body)).build();
        String responseString = null;
        try {
            Response response = client.newCall(requestBuild).execute();
            responseString = response.body().string();
        }
        catch (IOException e) {
            logger.error("\u8c03\u7528\u96c6\u6210\u5e73\u53f0API\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        logger.info("\u8c03\u7528\u96c6\u6210\u5e73\u53f0API\u7ed3\u679c\uff1a{}", (Object)responseString);
        body = "{\"clientId\":\"cassmall_sit\",\"clientSecret\":\"a04f8b89a2ee411aa44b58dbf651205d\",\"sso\":false,\"tenantCode\":\"Cass\",\"username\":\"62a98e8cfb022f0001500844@cassmall.com\"}";
        HttpRequest httpRequest = HttpUtil.createPost((String)"https://janus-inte.xforceplus.com");
        ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)httpRequest.header("Authentication", "casstime-extend2022071317441713479905")).header("tenantCode", "Cass")).header("uiaSign", "8c74445a4e1a7f21375ba9d0b7cbec1d")).header("action", "DDFB20C090D82E2483514ECE234C6EF4")).header("rpcType", "http")).header("Accept-Encoding", "deflate")).header("serialNo", "1231243253456345435");
        httpRequest.body(body, "application/json;charset=UTF-8");
        HttpResponse response = httpRequest.execute();
        System.out.println(JSON.toJSONString((Object)response));
        System.out.println(JSON.toJSONString((Object)response.body()));
    }

    public static void main(String[] args) {
        Map jsonObject = (Map)JSONObject.parseObject((String)"{\"code\":\"fa8818fda84091943bfedc2fbd01828f\",\"grant_type\":\"authorization_code\",\"secret\":\"ee0a3cf69aa0454bace49b6b673e5b3c\",\"redirect_uri\":\"na\",\"client_id\":\"tg_chptest-sit\"}", (TypeReference)new TypeReference<Map<String, String>>(){}, (JSONReader.Feature[])new JSONReader.Feature[0]);
        try {
            Response response = OkHttpClientUtil.doFormPost("https://paas-s.xforceplus.com/oidc/access-token", null, null, jsonObject);
            System.out.println(response.body().string());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

