/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.pscc.common.bot;

import com.xforceplus.pscc.common.bot.BotConfig;
import com.xforceplus.pscc.common.bot.BotHelper;
import com.xforceplus.pscc.common.exception.ApplicationException;
import com.xforceplus.pscc.common.util.OkHttpClientUtil;
import java.util.HashMap;
import java.util.List;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class BotService {
    private static final Logger log = LoggerFactory.getLogger(BotService.class);
    private final BotConfig botConfig;

    public void sendInfo(String text) throws Exception {
        String url = this.botConfig.getDingBotUrl() + "/send?access_token=" + this.botConfig.getDingBotToken() + BotHelper.getTimestampAndSign(this.botConfig.getDingBotKey());
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        String body = BotHelper.getText(text, this.botConfig.getWarningCall());
        Response resp = OkHttpClientUtil.doPost(url, headerMap, null, body);
        if (HttpStatus.OK.value() != resp.code()) {
            String message = null;
            if (resp.body() != null) {
                message = resp.body().string();
            }
            throw new ApplicationException("\u8fd4\u56de\u5931\u8d25!code:{},message:{}", resp.code(), message);
        }
    }

    public void sendInfo(String text, List<String> phones) throws Exception {
        String url = this.botConfig.getDingBotUrl() + "/send?access_token=" + this.botConfig.getDingBotToken() + BotHelper.getTimestampAndSign(this.botConfig.getDingBotKey());
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        String body = BotHelper.getText(text, phones);
        Response resp = OkHttpClientUtil.doPost(url, headerMap, null, body);
        if (HttpStatus.OK.value() != resp.code()) {
            String message = null;
            if (resp.body() != null) {
                message = resp.body().string();
            }
            throw new ApplicationException("\u8fd4\u56de\u5931\u8d25!code:{},message:{}", resp.code(), message);
        }
    }

    public void sendInfo(String text, String dingBotToken, String dingBotKey, List<String> phones) throws Exception {
        String url = this.botConfig.getDingBotUrl() + "/send?access_token=" + dingBotToken + BotHelper.getTimestampAndSign(dingBotKey);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        String body = BotHelper.getText(text, phones);
        Response resp = OkHttpClientUtil.doPost(url, headerMap, null, body);
        if (HttpStatus.OK.value() != resp.code()) {
            String message = null;
            if (resp.body() != null) {
                message = resp.body().string();
            }
            throw new ApplicationException("\u8fd4\u56de\u5931\u8d25!code:{},message:{}", resp.code(), message);
        }
    }

    public BotService(BotConfig botConfig) {
        this.botConfig = botConfig;
    }
}

