/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.pscc.common.intercept;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Maps;
import com.xforceplus.pscc.common.intercept.TraceContext;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class WebLogAspect {
    private static final Logger log = LoggerFactory.getLogger(WebLogAspect.class);
    ThreadLocal<Long> startTime = new ThreadLocal();

    @Pointcut(value="execution(public * com.xforceplus.ultraman..*Controller.*(..)) && !execution(public * com.xforceplus.ultraman.oqsengine.sdk.controller..*Controller.*(..))")
    public void webLog() {
    }

    @Before(value="webLog()")
    public void doBefore(JoinPoint joinPoint) throws Throwable {
        this.startTime.set(System.currentTimeMillis());
        try {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (attributes == null) {
                return;
            }
            HttpServletRequest request = attributes.getRequest();
            this.writeAppRequest(joinPoint, request);
        }
        catch (Exception ex) {
            log.error("\u62e6\u622a\u53c2\u6570\u8bb0\u5f55\u4e0b\u8bf7\u6c42\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff1a" + ex);
        }
    }

    @AfterReturning(returning="ret", pointcut="webLog()")
    public void doAfterReturning(Object ret) {
        try {
            Long time = System.currentTimeMillis() - this.startTime.get();
            this.startTime.remove();
            this.writeAppResponse(ret, time);
        }
        catch (Exception e) {
            log.error("\u62e6\u622a\u8fd4\u56de\u8bb0\u5f55\u4e0b\u8fd4\u56de\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\uff1a" + e);
        }
    }

    private void writeAppRequest(JoinPoint joinPoint, HttpServletRequest request) {
        StringBuffer requestParm = new StringBuffer();
        if (joinPoint.getArgs() != null && joinPoint.getArgs().length > 0) {
            for (int i = 0; i < joinPoint.getArgs().length; ++i) {
                requestParm.append(JSON.toJSONString((Object)joinPoint.getArgs()[i], (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            }
        }
        HashMap logEntity = Maps.newHashMap();
        logEntity.put("Title", "\u8bf7\u6c42\u62a5\u6587-" + request.getMethod());
        logEntity.put("TraceId", TraceContext.getContextTraceId());
        logEntity.put("Name", request.getRequestURI().substring(request.getRequestURI().lastIndexOf("/") + 1));
        logEntity.put("Url", request.getRequestURL().toString());
        logEntity.put("Ip", request.getRemoteAddr());
        logEntity.put("RequestStr", requestParm.toString());
        log.info(JSON.toJSONString((Object)logEntity));
    }

    private void writeAppResponse(Object ret, Long time) {
        HashMap logEntity = Maps.newHashMap();
        logEntity.put("Title", "\u8fd4\u56de\u62a5\u6587");
        logEntity.put("TraceId", TraceContext.getContextTraceId());
        logEntity.put("ResponseStr", ret);
        logEntity.put("Time", time);
        log.info(JSON.toJSONString((Object)logEntity));
    }
}

