/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.pscc.common.starter;

import com.xforceplus.pscc.common.bot.BotConfig;
import com.xforceplus.pscc.common.bot.BotService;
import com.xforceplus.pscc.common.bot.task.DefaultWarningImpl;
import com.xforceplus.pscc.common.bot.task.DingdingWarning;
import com.xforceplus.pscc.common.bot.task.ExceptionWarning;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ExceptionWarningConfiguration {
    @Autowired
    private BotConfig botConfig;
    @Autowired
    private BotService botService;
    @Value(value="${spring.profiles.active:default}")
    private String env;
    @Value(value="${spring.application.name:default}")
    private String appName;

    @Bean
    public ExceptionWarning initializationExceptionWarning() {
        if (StringUtils.isNotBlank((CharSequence)this.botConfig.getDingBotToken()) && StringUtils.isNotBlank((CharSequence)this.botConfig.getDingBotKey())) {
            ScheduledThreadPoolExecutor warningExecutor = new ScheduledThreadPoolExecutor(10, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("exception-warning-pool-%d").daemon(true).build());
            return new DingdingWarning(this.botConfig, this.botService, warningExecutor, this.appName, this.env);
        }
        return new DefaultWarningImpl();
    }
}

