/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.pscc.common.wapper;

import cn.hutool.core.date.SystemClock;
import com.xforceplus.pscc.common.exception.ApplicationException;
import com.xforceplus.pscc.common.wapper.EntityEnum;
import com.xforceplus.pscc.common.wapper.EntityMapper;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.EntityId;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.EntityInstance;
import com.xforceplus.ultraman.oqsengine.sdk.business.meta.service.BusinessFacade;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpFactory;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.service.EntityService;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.annotation.OqsTransactional;
import com.xforceplus.ultraman.oqsengine.sdk.util.RequestBuilder;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionOp;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.FieldCondition;
import io.vavr.control.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class EntityMapperWrapper
implements EntityMapper,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger((String)"ULTRAMAN");
    private EntityMapperWrapper entityMapperWrapper;
    @Autowired(required=false)
    private BusinessFacade businessFacade;
    @Autowired(required=false)
    private EntityService entityService;

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        Map map = applicationContext.getBeansOfType(EntityMapperWrapper.class);
        map.forEach((key, value) -> {
            this.entityMapperWrapper = value;
        });
    }

    @Override
    public IEntityClass getEntityClass(String entityCode) {
        return this.businessFacade.load(entityCode);
    }

    @Override
    public IEntityClass getEntityClass(EntityEnum entityEnum) {
        return this.businessFacade.load(entityEnum.getValue());
    }

    @Override
    public <T> T transactionalExecute(Callable<T> callable) {
        Either either = this.entityService.transactionalExecute(callable);
        return (T)either.getOrElseThrow(ApplicationException::new);
    }

    @Override
    public List<IEntityClass> getEntityClasss() {
        return this.entityService.getEntityClasss();
    }

    @Override
    public Long create(EntityEnum entityEnum, Map<String, Object> entity) {
        IEntityClass entityClass = this.getEntityClass(entityEnum.getValue());
        Long id = this.businessFacade.create(entityClass, entity);
        if (id == null || id <= 0L) {
            throw new ApplicationException("\u4fdd\u5b58\u5931\u8d25\uff01id\uff1a" + id);
        }
        return id;
    }

    @Override
    @OqsTransactional(rollbackFor={Exception.class})
    public List<Long> createLoop(EntityEnum entityEnum, List<Map<String, Object>> entityList) {
        if (CollectionUtils.isEmpty(entityList)) {
            throw new ApplicationException("\u4fdd\u5b58\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IEntityClass entityClass = this.getEntityClass(entityEnum.getValue());
        ArrayList<Long> ids = new ArrayList<Long>();
        entityList.forEach(entity -> {
            Long id = this.businessFacade.create(entityClass, entity);
            if (id == null || id <= 0L) {
                throw new ApplicationException("\u4fdd\u5b58\u5931\u8d25\uff01id\uff1a" + id);
            }
            ids.add(id);
        });
        return ids;
    }

    @Override
    public Integer createMulti(EntityEnum entityEnum, List<Map<String, Object>> entityList) {
        if (CollectionUtils.isEmpty(entityList)) {
            throw new ApplicationException("\u4fdd\u5b58\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IEntityClass entityClass = this.getEntityClass(entityEnum.getValue());
        Integer count = this.businessFacade.createMulti(entityClass, entityList);
        if (count == null || count <= 0 || count.intValue() != entityList.size()) {
            throw new ApplicationException("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return count;
    }

    @Override
    public void deleteById(EntityEnum entityEnum, long id) {
        IEntityClass entityClass = this.getEntityClass(entityEnum.getValue());
        Integer i = this.businessFacade.deleteOne(new EntityId(entityClass, id));
        if (i == null || i < 1) {
            throw new ApplicationException("\u5220\u9664\u5931\u8d25\uff01id\uff1a" + id);
        }
    }

    @Override
    public Integer deleteByIds(EntityEnum entityEnum, List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new ApplicationException("\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IEntityClass entityClass = this.getEntityClass(entityEnum.getValue());
        return this.businessFacade.deleteMulti(ids.stream().map(id -> new EntityId(entityClass, id.longValue())).collect(Collectors.toList()));
    }

    @Override
    public Integer deleteByCondition(EntityEnum entityEnum, RequestBuilder requestBuilder) {
        if (requestBuilder == null) {
            throw new ApplicationException("\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ConditionQueryRequest request = requestBuilder.build();
        if (CollectionUtils.isEmpty((Collection)request.getConditions().getFields())) {
            throw new ApplicationException("\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == request.getPageNo()) {
            request.setPageNo(Integer.valueOf(1));
        }
        if (null == request.getPageSize()) {
            request.setPageSize(Integer.valueOf(10000));
        }
        IEntityClass entityClass = this.getEntityClass(entityEnum.getValue());
        return this.businessFacade.deleteByConditionByBatch(entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)request));
    }

    @Override
    public void updateById(EntityEnum entityEnum, long id, Map<String, Object> entity) {
        if (MapUtils.isEmpty(entity)) {
            throw new ApplicationException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IEntityClass entityClass = this.getEntityClass(entityEnum.getValue());
        entity.put("update_time", SystemClock.now());
        Integer i = this.businessFacade.updateById(new EntityId(entityClass, id), entity);
        if (i == null || i < 1) {
            throw new ApplicationException("\u66f4\u65b0\u5931\u8d25\uff01id\uff1a" + id);
        }
    }

    @Override
    @OqsTransactional(rollbackFor={Exception.class})
    public Integer updateByIds(EntityEnum entityEnum, List<Long> ids, Map<String, Object> entity) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new ApplicationException("\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (MapUtils.isEmpty(entity)) {
            throw new ApplicationException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IEntityClass entityClass = this.getEntityClass(entityEnum.getValue());
        ids.forEach(id -> {
            Integer i = this.businessFacade.updateById(new EntityId(entityClass, id.longValue()), entity);
            if (i == null || i < 1) {
                throw new ApplicationException("\u66f4\u65b0\u5931\u8d25\uff01id\uff1a" + id);
            }
        });
        return ids.size();
    }

    @Override
    public Integer updateMulti(EntityEnum entityEnum, List<Map<String, Object>> entityList) {
        if (CollectionUtils.isEmpty(entityList)) {
            throw new ApplicationException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IEntityClass entityClass = this.getEntityClass(entityEnum.getValue());
        return this.businessFacade.updateMulti(entityClass, entityList);
    }

    @Override
    public Integer updateByCondition(EntityEnum entityEnum, RequestBuilder requestBuilder, Map<String, Object> entity) {
        if (MapUtils.isEmpty(entity)) {
            throw new ApplicationException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Long> ids = this.findIdsByCondition(entityEnum, requestBuilder);
        if (CollectionUtils.isEmpty(ids)) {
            return 0;
        }
        if (ids.size() == 1) {
            this.updateById(entityEnum, ids.get(0), entity);
            return 1;
        }
        return this.entityMapperWrapper.updateByIds(entityEnum, ids, entity);
    }

    @Override
    public Integer replaceById(EntityEnum entityEnum, long id, Map<String, Object> entity) {
        if (MapUtils.isEmpty(entity)) {
            throw new ApplicationException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IEntityClass entityClass = this.getEntityClass(entityEnum.getValue());
        entity.put("update_time", SystemClock.now());
        return this.businessFacade.replaceById(new EntityId(entityClass, id), entity);
    }

    @Override
    public Map<String, Object> findOne(EntityEnum entityEnum, long id) {
        IEntityClass entityClass = this.getEntityClass(entityEnum.getValue());
        Optional instance = this.businessFacade.findOne(new EntityId(entityClass, id));
        return instance.map(EntityInstance::value).orElse(null);
    }

    @Override
    public <T> T findOne(EntityEnum entityEnum, long id, Function<Map<String, Object>, T> toEntityFunction) {
        return toEntityFunction.apply(this.findOne(entityEnum, id));
    }

    @Override
    public List<Map<String, Object>> findByIds(EntityEnum entityEnum, List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new ApplicationException("\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RequestBuilder requestBuilder = new RequestBuilder().field("id", ConditionOp.in, ids);
        return this.findByCondition(entityEnum, requestBuilder);
    }

    @Override
    public <T> List<T> findByIds(EntityEnum entityEnum, List<Long> ids, Function<Map<String, Object>, T> toEntityFunction) {
        List<Map<String, Object>> condition = this.findByIds(entityEnum, ids);
        return condition.stream().map(toEntityFunction).collect(Collectors.toList());
    }

    @Override
    public Long count(EntityEnum entityEnum, RequestBuilder requestBuilder) {
        ConditionQueryRequest request = requestBuilder.build();
        if (null == request.getPageNo()) {
            request.setPageNo(Integer.valueOf(1));
        }
        if (null == request.getPageSize()) {
            request.setPageSize(Integer.valueOf(10000));
        }
        IEntityClass entityClass = this.getEntityClass(entityEnum.getValue());
        return this.businessFacade.count(entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)request));
    }

    @Override
    public List<Map<String, Object>> findByCondition(EntityEnum entityEnum, Map<String, Object> entityMap) {
        if (MapUtils.isEmpty(entityMap)) {
            throw new ApplicationException("\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        RequestBuilder requestBuilder = new RequestBuilder();
        entityMap.forEach((key, value) -> requestBuilder.field(key, ConditionOp.eq, new Object[]{value}));
        return this.findByCondition(entityEnum, requestBuilder);
    }

    @Override
    public List<Map<String, Object>> findByCondition(EntityEnum entityEnum, RequestBuilder requestBuilder) {
        List fields;
        ConditionQueryRequest request = requestBuilder.build();
        if (null == request.getPageNo()) {
            request.setPageNo(Integer.valueOf(1));
        }
        if (null == request.getPageSize()) {
            request.setPageSize(Integer.valueOf(10000));
        }
        if (CollectionUtils.isNotEmpty((Collection)(fields = request.getConditions().getFields()))) {
            request.getConditions().setFields(this.filterBlank(fields));
        }
        if (CollectionUtils.isEmpty((Collection)request.getConditions().getFields()) && CollectionUtils.isEmpty((Collection)request.getConditions().getEntities())) {
            throw new ApplicationException("\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IEntityClass entityClass = this.getEntityClass(entityEnum.getValue());
        return this.businessFacade.findByCondition(entityClass, (ExpRel)ExpFactory.createFrom((ConditionQueryRequest)request)).getRows().stream().map(EntityInstance::value).collect(Collectors.toList());
    }

    public List<FieldCondition> filterBlank(List<FieldCondition> list) {
        if (null == list) {
            return list;
        }
        ArrayList<FieldCondition> list2 = new ArrayList<FieldCondition>();
        for (FieldCondition field : list) {
            if (ConditionOp.eq.name().equals(field.getOperation().name()) || ConditionOp.ne.name().equals(field.getOperation().name())) {
                if (CollectionUtils.isEmpty((Collection)field.getValue()) || field.getValue().size() > 1) {
                    throw new ApplicationException(field.getCode() + "\u7684\u53c2\u6570\u9519\u8bef!");
                }
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)field.getValue().get(0)))) continue;
                list2.add(field);
                continue;
            }
            list2.add(field);
        }
        return list2;
    }

    @Override
    public List<Long> findIdsByCondition(EntityEnum entityEnum, RequestBuilder requestBuilder) {
        requestBuilder.item(new String[]{"id"});
        List<Map<String, Object>> result = this.findByCondition(entityEnum, requestBuilder);
        return result.stream().map(map -> MapUtils.getLong((Map)map, (Object)"id")).collect(Collectors.toList());
    }

    @Override
    public <T> List<T> findByCondition(EntityEnum entityEnum, RequestBuilder requestBuilder, Function<Map<String, Object>, T> toEntityFunction) {
        List<Map<String, Object>> condition = this.findByCondition(entityEnum, requestBuilder);
        return condition.stream().map(toEntityFunction).collect(Collectors.toList());
    }

    @Override
    public <T> T findOneByCondition(EntityEnum entityEnum, RequestBuilder requestBuilder, Function<Map<String, Object>, T> toEntityFunction) {
        requestBuilder.pageSize(Integer.valueOf(1));
        requestBuilder.pageNo(Integer.valueOf(1));
        List<Map<String, Object>> condition = this.findByCondition(entityEnum, requestBuilder);
        if (CollectionUtils.isEmpty(condition)) {
            return null;
        }
        return toEntityFunction.apply(condition.get(0));
    }
}

